/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ru.softlogic.hdw.dev.epp.CryptoException;
import ru.softlogic.hdw.dev.epp.EncryptMode;
import ru.softlogic.hdw.dev.epp.MacMode;

public class CryptoUtils {
    public static byte[] mac(MacMode mode, byte[] key, byte[] data, int begin, int len) throws CryptoException {
        try {
            if (mode == MacMode.X9_19) {
                Mac m = Mac.getInstance("ISO9797Alg3Mac", "BC");
                m.init(new SecretKeySpec(key, "DES"));
                m.update(data, begin, len);
                return m.doFinal();
            }
            Mac m = Mac.getInstance("DES", "BC");
            m.init(new SecretKeySpec(key, "DES"));
            m.update(data, begin, len);
            return m.doFinal();
        }
        catch (Exception ex) {
            throw new CryptoException(ex);
        }
    }

    public static byte[] mac(MacMode mode, byte[] key, byte[] data) throws CryptoException {
        return CryptoUtils.mac(mode, key, data, 0, data.length - 1);
    }

    public static byte[] encrypt(EncryptMode mode, byte[] key, byte[] data) throws CryptoException {
        try {
            if (mode == EncryptMode.Ecb) {
                Cipher c = Cipher.getInstance("DESede/ECB/NoPadding", "BC");
                c.init(1, new SecretKeySpec(key, "DES"));
                return c.update(data);
            }
            Cipher c = Cipher.getInstance("DES/CBC/NoPadding", "BC");
            c.init(1, new SecretKeySpec(key, "DES"));
            return c.update(data);
        }
        catch (Exception ex) {
            throw new CryptoException(ex);
        }
    }

    public static byte[] decrypt(EncryptMode mode, byte[] key, byte[] data) throws CryptoException {
        try {
            if (mode == EncryptMode.Ecb) {
                Cipher c = Cipher.getInstance("DESede/ECB/NoPadding", "BC");
                c.init(2, new SecretKeySpec(key, "DES"));
                return c.update(data);
            }
            Cipher c = Cipher.getInstance("DES/CBC/NoPadding", "BC");
            c.init(2, new SecretKeySpec(key, "DES"));
            return c.update(data);
        }
        catch (Exception ex) {
            throw new CryptoException(ex);
        }
    }

    public static byte[] zeroPadding(byte[] data, int blockSize) {
        if (data == null) {
            throw new NullPointerException("Data is not set");
        }
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size must be positive");
        }
        if (data.length % blockSize != 0) {
            byte[] pd = new byte[data.length + (blockSize - data.length % blockSize)];
            System.arraycopy(data, 0, pd, 0, data.length);
            return pd;
        }
        return data;
    }

    public static byte[] getFirstOf(byte[] data, int size) {
        if (data == null) {
            throw new NullPointerException("Data is not set");
        }
        if (size <= 0 || size > data.length) {
            throw new IllegalArgumentException("Block size must be positive");
        }
        if (data.length > size) {
            byte[] pd = new byte[size];
            System.arraycopy(data, 0, pd, 0, size);
            return pd;
        }
        return data;
    }
}

