/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cvd;

import ru.softlogic.hdw.dev.cvd.BarcodeHandler;
import ru.softlogic.hdw.dev.cvd.BaseDispenseOperation;
import ru.softlogic.hdw.dev.cvd.DispenseOperation;

public class BarcodeOperation
extends BaseDispenseOperation
implements BarcodeHandler {
    private final String regex;
    private String barcode;

    public BarcodeOperation(String regex, DispenseOperation.TimeoutAction timeoutAction) {
        super(timeoutAction);
        if ("".matches(regex)) {
            // empty if block
        }
        this.regex = regex;
    }

    public BarcodeOperation(String regex) {
        if ("".matches(regex)) {
            // empty if block
        }
        this.regex = regex;
    }

    @Override
    public BarcodeHandler getBarcodeHandler() {
        return this;
    }

    @Override
    public boolean onBarcode(String barcode) {
        if (barcode.matches(this.regex)) {
            this.barcode = barcode;
            return true;
        }
        return false;
    }

    public String getBarcode() {
        return this.barcode;
    }

    @Override
    public String toString() {
        return "BarcodeOperation{regex=" + this.regex + ", barcode=" + this.barcode + ", state=" + (Object)((Object)this.state) + ", timeoutAction=" + (Object)((Object)this.timeoutAction) + '}';
    }
}

