/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.crd.contactless.ContactlessCard;
import ru.softlogic.hdw.dev.crd.contactless.MifareClassic;
import ru.softlogic.hdw.dev.crd.contactless.MifareUltralight;
import ru.softlogic.hdw.dev.crd.contactless.RfidCardReader;
import ru.softlogic.hdw.dev.crd.contactless.RfidCardReaderDriver;
import ru.softlogic.hdw.dev.crd.contactless.RfidCardStateListener;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public abstract class BaseContactlessReader
extends BaseDevice
implements RfidCardReader,
RfidCardReaderDriver,
Runnable {
    public static final int CARD_MIFARE_ULTRALIGHT = 0;
    public static final int CARD_MIFARE_CLASSIC_1K = 8;
    public static final int CARD_MIFARE_CLASSIC_4K = 24;
    private final List<Thread> threads;
    private final SerialPort port;
    private final DeviceId deviceId;
    private final TaskBus bus;
    protected volatile int currCardState = 3;
    protected Logger log;
    protected RfidCardStateListener cardStateListener;
    protected volatile boolean enabled;
    private boolean isReleased;

    public BaseContactlessReader(DeviceId deviceId, SerialPort port, String baseDrvVersion, Logger log) {
        super(deviceId, baseDrvVersion, log);
        this.deviceId = deviceId;
        this.port = port;
        this.log = log;
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
        this.bus = new TaskBus(log);
        this.threads.add(new Thread((Runnable)this.bus, "DriverTaskBus"));
    }

    @Override
    public RfidCardReader getCardReader() {
        return this;
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public void enableDevice(RfidCardStateListener cardStateListener) {
        this.releasedChack();
        if (this.enabled) {
            throw new IllegalStateException("Device is already on");
        }
        this.cardStateListener = cardStateListener;
        this.enabled = true;
    }

    @Override
    public void disableDevice() {
        this.releasedChack();
        if (!this.enabled) {
            throw new IllegalStateException("Device is already off");
        }
        this.enabled = false;
    }

    @Override
    public boolean isEnabled() {
        this.releasedChack();
        return this.enabled;
    }

    @Override
    public void release() {
        this.releasedChack();
        this.cardStateListener = null;
        this.isReleased = true;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start cardreader driver");
        if (this.port != null) {
            this.log.info((Object)("Port: " + SerialFmt.format((SerialPort)this.port)));
        }
        this.log.info((Object)("Driver: " + this.deviceId.getType() + ", number: " + this.deviceId.getNumber()));
        try {
            this._run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.port != null) {
            this.port.close();
        }
        this.log.info((Object)"Stop thread");
    }

    protected abstract void _run() throws InterruptedException;

    protected synchronized void notifyAboutNewCard(ContactlessCard card) {
        CardActivateNotifier cardActivateNotifier = new CardActivateNotifier(card);
        this.bus.addTask(cardActivateNotifier);
    }

    protected void releasedChack() {
        if (this.isReleased) {
            throw new IllegalStateException("Device was released");
        }
    }

    protected DeviceInfo createDeviceInfo() {
        DeviceInfo di = new DeviceInfo(this.deviceId.getDeviceClass(), this.deviceId.getType());
        if (this.port != null) {
            di.setPort(SerialFmt.format((SerialPort)this.port));
        }
        return di;
    }

    private class CardActivateNotifier
    implements Runnable {
        private final ContactlessCard card;

        public CardActivateNotifier(ContactlessCard card) {
            this.card = card;
        }

        @Override
        public void run() {
            if (BaseContactlessReader.this.cardStateListener != null) {
                if (this.card instanceof MifareClassic) {
                    BaseContactlessReader.this.cardStateListener.onMifareClassicActivate((MifareClassic)this.card);
                } else if (this.card instanceof MifareUltralight) {
                    BaseContactlessReader.this.cardStateListener.onMifareUltralightActivate((MifareUltralight)this.card);
                }
            }
        }

        public String toString() {
            return "CardStateNotifier{state=" + this.card + '}';
        }
    }
}

