/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd.contactless;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.crd.CardReaderOptions;
import ru.softlogic.hdw.dev.crd.contactless.RfidCardReaderDriver;
import ru.softlogic.io.serial.SerialPort;

public class RfidCardReaderFactory {
    public static RfidCardReaderDriver createDriver(String type, SerialPort port, CardReaderOptions options, Logger log) throws CreatingException {
        if (type == null) {
            throw new CreatingException("Type is not set");
        }
        if (log == null) {
            throw new CreatingException("Logger is not set");
        }
        if (options == null) {
            throw new CreatingException("Options is not set");
        }
        String pkg = "ru.softlogic.hardware.crd." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            RfidCardReaderDriver cr = (RfidCardReaderDriver)cl.getConstructor(SerialPort.class, CardReaderOptions.class, Logger.class).newInstance(port, options, log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }
}

