/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.cashdisp.BoxOutListener;
import ru.softlogic.hdw.dev.cashdisp.BoxState;
import ru.softlogic.hdw.dev.cashdisp.BoxStateListener;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDescriptor;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserFactory;
import ru.softlogic.hdw.dev.cashdisp.EmptyChannel;
import ru.softlogic.hdw.handling.CashInfo;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxInfo;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.io.Serializator;

public abstract class BaseCashDispenserDriver
extends BaseDevice
implements CashDispenser,
CashDispenserDriver,
Runnable {
    private static final String BASE_VERSION = "3.2.0";
    private final SerialPort port;
    private final Serializator serializator;
    private final Logger log;
    private CashDispenserDescriptor descriptor;
    private BoxOutListener boxOutListener;
    private final List<Thread> threads;
    private final Set<BoxStateListener> boxStateListeners;
    private final Map<Integer, BoxState> states;

    public BaseCashDispenserDriver(DeviceId deviceId, SerialPort port, Serializator serializator, Logger log) {
        super(deviceId, BASE_VERSION, log);
        if (port == null) {
            throw new NullPointerException("Serial port is null");
        }
        if (serializator == null) {
            throw new NullPointerException("Serializator is null");
        }
        this.log = log;
        this.port = port;
        this.serializator = serializator;
        this.boxStateListeners = new HashSet<BoxStateListener>();
        this.states = new HashMap<Integer, BoxState>();
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
    }

    @Override
    public synchronized CashDispenserDescriptor getDescriptor() {
        if (this.descriptor == null) {
            try {
                DeviceId did = this.getDeviceId();
                this.descriptor = CashDispenserFactory.createDescriptor(DeviceClass.getCode(did.getDeviceClass()), did.getType());
            }
            catch (CreatingException ex) {
                this.log.error((Object)"Error on extracting descriptor", (Throwable)ex);
            }
        }
        return this.descriptor;
    }

    @Override
    public final void setBoxOutListener(BoxOutListener boxOutListener) {
        if (boxOutListener == null) {
            throw new NullPointerException("BoxOutListener is null");
        }
        this.boxOutListener = boxOutListener;
    }

    @Override
    public final CashDispenser getDispenser() {
        return this;
    }

    @Override
    public final List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public Map<Integer, BoxState> getBoxState() {
        return this.states;
    }

    @Override
    public List<EmptyChannel> getEmptyChannels() {
        return Collections.emptyList();
    }

    protected void printDispenserInfo() {
        this.log.info((Object)"========================================================");
        this.printStore(this.getStore());
    }

    private void printStore(Store st) {
        this.log.info((Object)("Store title: " + st.getTitle() + ", box count: " + st.getBoxes().length));
        for (Box box : st.getBoxes()) {
            this.log.info((Object)("    " + box));
            Map<Denomination, Integer> counts = box.getCounts();
            for (Map.Entry<Denomination, Integer> entry : counts.entrySet()) {
                this.log.info((Object)("        " + SumFormatter.asStr(entry.getKey()) + ", count: " + entry.getValue()));
            }
        }
        this.log.info((Object)"========================================================");
    }

    protected void notifyBoxOut(int boxId) {
        this.log.info((Object)("Notify box out: " + boxId));
        if (this.boxOutListener != null) {
            this.boxOutListener.onBoxOut(boxId);
        }
    }

    protected void notifyBoxState(int boxId, BoxState state) {
        if (boxId < 0) {
            throw new IllegalArgumentException("BoxId must be positive");
        }
        if (state == null) {
            throw new IllegalArgumentException("BoxState is null");
        }
        BoxState last = this.states.get(boxId);
        if (last == null || !last.equals(state)) {
            this.log.info((Object)("Notify box state: " + boxId + "->" + state));
            this.states.put(boxId, state);
            for (BoxStateListener listener : this.boxStateListeners) {
                listener.onChange(boxId, state);
            }
        }
    }

    @Override
    public void addBoxStateListener(BoxStateListener boxStateListener) {
        if (boxStateListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.boxStateListeners.add(boxStateListener);
    }

    @Override
    public void removeBoxStateListener(BoxStateListener boxStateListener) {
        if (boxStateListener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.boxStateListeners.remove(boxStateListener);
    }

    protected DeviceInfo createDeviceInfo(Set<String> currencies, Set<Denomination> denominations) {
        DeviceId did = this.getDeviceId();
        DeviceInfo di = new DeviceInfo(did.getDeviceClass(), did.getType());
        di.setPort(SerialFmt.format((SerialPort)this.port));
        Box[] bs = this.getDispenser().getStore().getBoxes();
        HashMap<Integer, BoxInfo> boxes = new HashMap<Integer, BoxInfo>();
        for (int i = 0; i < bs.length; ++i) {
            boxes.put(i, bs[i].getBoxInfo());
        }
        CashInfo ci = new CashInfo(Collections.unmodifiableSet(currencies), Collections.unmodifiableSet(denominations), boxes);
        di.setCashInfo(ci);
        return di;
    }

    protected DeviceInfo createDeviceInfo() {
        return this.createDeviceInfo(new HashSet<String>(), new HashSet<Denomination>());
    }

    protected final InternalStorage createStorage() {
        DeviceId did = this.getDeviceId();
        return new InternalStorage(this.serializator, DeviceClass.asStr(did.getDeviceClass()));
    }
}

