/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.BoxedCashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.ValidBoxVisitor;
import ru.softlogic.storage.cash.Box;

class AvailableVisitor
extends ValidBoxVisitor {
    private final Map<Denomination, Integer> available = new HashMap<Denomination, Integer>();
    private final String currency;
    private final int max;

    public AvailableVisitor(BoxedCashDispenserDriver drv, String currency, int max, Logger log) {
        super(drv, log);
        this.currency = currency;
        this.max = max;
    }

    @Override
    public void onValidBox(Box box, Denomination den, int count) {
        if (this.currency.equals(den.getCurrency())) {
            int acceptable = Math.min(count, this.max);
            Integer cnt = this.available.get(den);
            this.available.put(den, acceptable + (cnt == null ? 0 : cnt));
        }
    }

    public Map<Denomination, Integer> getAvailable() {
        return this.available;
    }
}

