/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashacc;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.SerialDeviceSection;
import ru.softlogic.hdw.dev.cashacc.CvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.CvrOptions;
import ru.softlogic.io.serial.SerialPort;

public class CvrSection
extends SerialDeviceSection {
    public static final String PROFILE = "sorter-profile";
    private CvrConfiguration cac;

    public CvrSection() {
    }

    public CvrSection(CvrConfiguration cac) {
        this.cac = cac;
    }

    @Override
    public String getKey() {
        return "coin-acc";
    }

    @Override
    public Element generate(Document doc) {
        return this.generate(doc, this.cac);
    }

    @Override
    public void generateOptions(Document doc, Element root) {
        if (this.cac.getOptions() != null && this.cac.getOptions().getSorterProfile() != null && !this.cac.getOptions().getSorterProfile().isEmpty()) {
            this.writeOption(doc, root, PROFILE, this.cac.getOptions().getSorterProfile());
        }
    }

    @Override
    public void parce(Element element) {
        boolean enable = this.getEnable(element);
        String type = this.getDriver(element);
        SerialPort port = this.getSerialPort(element);
        Map<String, String> opt = this.readOptions(element);
        this.cac = new CvrConfiguration(enable, type, port, new CvrOptions(opt.get(PROFILE)));
    }

    public CvrConfiguration getConfiguration() {
        return this.cac;
    }
}

