/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Map;

class SimpleEncoder
extends CharsetEncoder {
    private static final byte UNK = 63;
    private final Map<Character, Byte> map;

    public SimpleEncoder(Charset cs, Map<Character, Byte> map, float averageBytesPerChar, float maxBytesPerChar) {
        super(cs, averageBytesPerChar, maxBytesPerChar);
        this.map = map;
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        while (in.hasRemaining()) {
            if (out.remaining() < 1) {
                return CoderResult.OVERFLOW;
            }
            char ch = in.get();
            Byte res = this.map.get(Character.valueOf(ch));
            out.put(res != null ? (byte)res : (byte)63);
        }
        return CoderResult.UNDERFLOW;
    }
}

