/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Map;

class SimpleDecoder
extends CharsetDecoder {
    private final Map<Byte, Character> map;

    public SimpleDecoder(Charset cs, Map<Byte, Character> map, float averageCharsPerByte, float maxCharsPerByte) {
        super(cs, averageCharsPerByte, maxCharsPerByte);
        this.map = map;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            byte b = in.get();
            if (!out.hasRemaining()) {
                return this.overflow(in);
            }
            Character res = this.map.get(b);
            out.put(res != null ? (char)res.charValue() : (char)'?');
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult overflow(ByteBuffer in) {
        in.position(in.position() - 1);
        return CoderResult.OVERFLOW;
    }
}

