/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.ConnectedDevice;
import ru.softlogic.hardware.search.ConnectedDeviceResult;
import ru.softlogic.hardware.search.PortRunnable;
import ru.softlogic.hardware.search.SearchFilter;
import ru.softlogic.hardware.search.SearchListener;
import ru.softlogic.hardware.search.SearchResult;
import ru.softlogic.hardware.search.SerialPortRunnable;
import ru.softlogic.hardware.search.UsbPortRunnable;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;

public class DeviceSearcher {
    protected Logger log = Logger.getLogger(DeviceSearcher.class);
    private final ExecutorService service;
    private final int deep;
    private final boolean getInfo;
    private final List<PortRunnable> prs = new LinkedList<PortRunnable>();

    public DeviceSearcher(int threadCount, int deep, boolean getInfo) {
        if (threadCount < 1 || threadCount > 30) {
            throw new IllegalArgumentException("Thread count must be in range 1..30");
        }
        this.service = Executors.newFixedThreadPool(threadCount);
        this.deep = deep;
        this.getInfo = getInfo;
    }

    public void shutdown() {
        this.service.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        List<PortRunnable> list = this.prs;
        synchronized (list) {
            for (PortRunnable pr : this.prs) {
                pr.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public SearchResult search(String[] ports, Collection<DeviceDescription> dds, List<ConnectedDevice> founded, SearchFilter filter, SearchListener searchListener) {
        if (ports == null) {
            throw new NullPointerException("Ports");
        }
        if (dds == null) {
            throw new NullPointerException("DeviceDescriptions");
        }
        if (filter == null) {
            throw new NullPointerException("Filter ");
        }
        long begin = System.currentTimeMillis();
        LinkedList<Future<ConnectedDeviceResult>> results = new LinkedList<Future<ConnectedDeviceResult>>();
        List<PortRunnable> list = this.prs;
        synchronized (list) {
            void var12_16;
            this.prs.clear();
            String[] stringArray = ports;
            int n = stringArray.length;
            boolean bl = false;
            while (var12_16 < n) {
                block17: {
                    PortRunnable pr;
                    block16: {
                        PortType pt;
                        String sp;
                        block15: {
                            sp = stringArray[var12_16];
                            pt = PortScanner.suggestType((String)sp);
                            if (pt != PortType.SerialPort) break block15;
                            pr = new SerialPortRunnable(new SerialPort(sp), dds, this.getConnectedDevice(sp, founded), filter, searchListener, this.deep, this.getInfo);
                            break block16;
                        }
                        if (pt != PortType.UsbPort) break block17;
                        pr = new UsbPortRunnable(new UsbPort(sp), dds, filter, searchListener, this.deep, this.getInfo);
                    }
                    this.prs.add(pr);
                    results.add(this.service.submit(pr));
                }
                ++var12_16;
            }
        }
        SearchResult sr = new SearchResult();
        LinkedList cds = new LinkedList();
        try {
            for (Future future : results) {
                ConnectedDeviceResult cd = (ConnectedDeviceResult)future.get();
                if (cd == null) continue;
                cd.addResult(sr);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            this.log.error((Object)"Error on execute", (Throwable)ex);
        }
        catch (Throwable ex) {
            this.log.error((Object)"Unknown error", ex);
        }
        sr.setTimeout(System.currentTimeMillis() - begin);
        return sr;
    }

    private ConnectedDevice getConnectedDevice(String port, List<ConnectedDevice> founded) {
        if (founded == null) {
            return null;
        }
        for (ConnectedDevice cd : founded) {
            if (!cd.getPort().getName().equals(port)) continue;
            return cd;
        }
        return null;
    }
}

