/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.hardware.currency.CashProfile;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Dimensions;
import ru.softlogic.hardware.currency.WrongNominalException;

public class Cash {
    private static final String PROP_FORMAT = "sumformat";
    private static final String PROP_SEPARATOR = ";";
    public static final String CURR_RUB = "RUB";
    public static final String CURR_UAH = "UAH";
    public static final String CURR_EUR = "EUR";
    public static final String CURR_USD = "USD";
    public static final String CURR_BGN = "BGN";
    private static final ResourceBundle bundle = ResourceBundle.getBundle(Cash.class.getPackage().getName() + ".resources");
    private static final Map<String, CashProfile> cashMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> cntMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> propMap;
    private static Map<Integer, Dimensions> dimensions;
    private static final Object sync;

    private Cash() {
    }

    public static synchronized Dimensions getDimensions(Denomination denomination) {
        Dimensions d;
        if (denomination == null || denomination.getType() == 1) {
            throw new IllegalArgumentException("Required note");
        }
        if (dimensions == null) {
            dimensions = new HashMap<Integer, Dimensions>();
            ResourceBundle db = ResourceBundle.getBundle(Cash.class.getPackage().getName() + ".dimensions");
            for (String s : db.keySet()) {
                String val;
                if (!s.matches("\\d+") || !(val = db.getString(s).trim()).matches("\\d{3}x\\d{2}")) continue;
                String[] vals = val.split("x");
                dimensions.put(Integer.parseInt(s), new Dimensions(Integer.parseInt(vals[0]), Integer.parseInt(vals[1]), 120));
            }
        }
        return (d = dimensions.get(denomination.getId())) != null ? d : Dimensions.DEFAULT;
    }

    public static Denomination getBill(String currency, int nominal) throws CashProfileException, WrongNominalException {
        CashProfile cp = Cash.getCashProfile(Cash.correctCode(currency));
        return cp.getBill(nominal);
    }

    public static Denomination getBill(String str) throws CashProfileException, WrongNominalException {
        Pattern pattern = Pattern.compile("(\\d{1,9}|0\\.\\d{1,2})\\s*([A-Z]{3})");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find() && matcher.groupCount() != 2) {
            throw new WrongNominalException("Wrong format: " + str + ", example: 100 USD");
        }
        try {
            return Cash.getBill(matcher.group(2), (int)(Float.parseFloat(matcher.group(1)) * 100.0f));
        }
        catch (NumberFormatException ex) {
            throw new WrongNominalException(ex);
        }
    }

    public static Denomination getCoin(String currency, int nominal) throws CashProfileException, WrongNominalException {
        CashProfile cp = Cash.getCashProfile(Cash.correctCode(currency));
        return cp.getCoin(nominal);
    }

    public static Denomination getDenomination(String str, int type) throws CashProfileException, WrongNominalException {
        Pattern pattern = Pattern.compile("(\\d{1,9}|0\\.\\d{1,2})\\s*([A-Z]{3})");
        Matcher matcher = pattern.matcher(str);
        if (matcher.find() && matcher.groupCount() != 2) {
            throw new WrongNominalException("Wrong format: " + str + ", example: 100 USD");
        }
        try {
            return Cash.getDenomination(matcher.group(2), (int)(Float.parseFloat(matcher.group(1)) * 100.0f), type);
        }
        catch (NumberFormatException ex) {
            throw new WrongNominalException(ex);
        }
    }

    public static Denomination getDenomination(String currency, int nominal, int type) throws CashProfileException, WrongNominalException {
        CashProfile cp = Cash.getCashProfile(Cash.correctCode(currency));
        switch (type) {
            case 0: {
                return cp.getBill(nominal);
            }
            case 1: {
                return cp.getCoin(nominal);
            }
        }
        throw new IllegalArgumentException("Unknown denomination type: " + type);
    }

    public static String correctCode(String id) throws CashProfileException {
        if (id == null) {
            throw new NullPointerException("Currency code is null");
        }
        String currencyCode = id.trim();
        if (!currencyCode.matches("[A-Z]{2,3}")) {
            throw new IllegalArgumentException("Wrong code: " + currencyCode + ". Currency code must contain 2 or 3 letter, ");
        }
        String mapKey = "map." + currencyCode;
        if (bundle.containsKey(mapKey)) {
            currencyCode = bundle.getString(mapKey);
        }
        if (currencyCode.length() == 3) {
            currencyCode = currencyCode.substring(0, 2);
        }
        return Cash.getCountryCurrency(currencyCode);
    }

    public static Locale getLocale(String country) throws CashProfileException {
        return Cash.getCashProfile(country).getLocale();
    }

    public static synchronized CashProfile getCashProfile(String code) throws CashProfileException {
        CashProfile cp;
        if (code == null) {
            throw new NullPointerException("Code is null");
        }
        if (code.length() != 3) {
            throw new CashProfileException("Wrong currency code: " + code);
        }
        if (propMap == null) {
            propMap = Cash.loadTemplateFromProp();
        }
        if ((cp = cashMap.get(code)) == null) {
            if (!cashMap.containsKey(code)) {
                Properties prop = new Properties();
                InputStream is = Cash.class.getResourceAsStream("curr_" + code + ".properties");
                if (is != null) {
                    try {
                        prop.load(is);
                        Denomination[] b = Cash.readByType(prop, code, "bill", 0);
                        Denomination[] c = Cash.readByType(prop, code, "coin", 1);
                        String dec = prop.getProperty("decimals", "2");
                        if (!dec.matches("\\d")) {
                            throw new CashProfileException("Param 'dec' is wrong");
                        }
                        String coinScale = prop.getProperty("coin-scale", "1");
                        if (!coinScale.matches("\\d+")) {
                            throw new CashProfileException("Param 'coin-scale' is wrong");
                        }
                        String locale = prop.getProperty("locale");
                        if (locale == null || !locale.matches("[a-z]{2}_[A-Z]{2}")) {
                            throw new CashProfileException("Param 'locale' is wrong");
                        }
                        String minBill = prop.getProperty("bill.min", "0");
                        if (!minBill.matches("\\d")) {
                            throw new CashProfileException("Param 'bill.min' is wrong");
                        }
                        String minCoin = prop.getProperty("coin.min", "0");
                        if (!minCoin.matches("\\d")) {
                            throw new CashProfileException("Param 'coin.min' is wrong");
                        }
                        String template = propMap.containsKey(code) ? propMap.get(code) : prop.getProperty("format");
                        cp = new CashProfile(code, b, b[Integer.parseInt(minBill)], c, c.length > 0 ? c[Integer.parseInt(minCoin)] : null, Integer.parseInt(dec), Integer.parseInt(coinScale), new Locale(locale.substring(0, 2), locale.substring(3, 5)), template);
                        cashMap.put(code, cp);
                        CashProfile cashProfile = cp;
                        return cashProfile;
                    }
                    catch (IOException ex) {
                        throw new CashProfileException("Currency " + code + " is not supported", ex);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            throw new CashProfileException("Currency " + code + " is not supported");
        }
        return cp;
    }

    private static Map<String, String> loadTemplateFromProp() {
        String[] formats;
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern ptrn = Pattern.compile("([A-Z]{2,3}):(.*)");
        String format = System.getProperty(PROP_FORMAT);
        if (format == null) {
            return map;
        }
        for (String tmpl : formats = format.split(PROP_SEPARATOR)) {
            Matcher m = ptrn.matcher(tmpl);
            if (!m.matches() || m.group(1) == null || m.group(2) == null) continue;
            map.put(m.group(1), m.group(2));
        }
        return map;
    }

    private static Denomination[] readByType(Properties prop, String code, String prefix, int type) {
        String val = prop.getProperty(prefix);
        if (val != null) {
            LinkedList<Denomination> res = new LinkedList<Denomination>();
            for (String nom : val.split(",")) {
                String[] paths = nom.split(":");
                if (paths.length != 2 || !paths[0].matches("\\d+") || !paths[1].matches("\\d+")) continue;
                Denomination den = new Denomination(Integer.parseInt(paths[1]), type, Integer.parseInt(paths[0]), code);
                res.add(den);
            }
            return res.toArray(new Denomination[res.size()]);
        }
        return new Denomination[0];
    }

    public static String getSystemCurrency() {
        return System.getProperty("currency", CURR_RUB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCountryCurrency(String id) throws CashProfileException {
        String cur;
        String code = id.toUpperCase();
        Object object = sync;
        synchronized (object) {
            cur = cntMap.get(code);
            if (cur == null) {
                if (!cntMap.containsKey(code)) {
                    InputStream is = Cash.class.getResourceAsStream("resources.properties");
                    if (is == null) {
                        throw new CashProfileException("Country code " + code + " is unknown");
                    }
                    try {
                        Properties prop = new Properties();
                        prop.load(is);
                        String currency = prop.getProperty("curr." + code);
                        if (currency == null) {
                            throw new CashProfileException("Mapping country->currency is not found for " + code);
                        }
                        if (currency.length() != 3) {
                            throw new CashProfileException("Wrong data in profile. Curr: " + currency);
                        }
                        cur = currency;
                        cntMap.put(code, cur);
                    }
                    catch (IOException ex) {
                        throw new CashProfileException("Country code " + code + " is unknown", ex);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                throw new CashProfileException("Country code " + code + " is unknown");
            }
        }
        return cur;
    }

    static {
        sync = new Object();
    }
}

