/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stubconsole.driver.handler;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import ru.softlogic.crypto.DesHelper;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.dev.epp.EppPinblockListener;
import ru.softlogic.hdw.dev.epp.PinblockRequest;
import ru.softlogic.utils.b;

public class PinblockHandler
implements Handler {
    private final TaskBus bus;
    private final PinblockRequest request;
    private final int comleteLen;
    private final int timeout;
    private final Logger log;
    private final EppPinblockListener listener;
    private boolean complete;
    private final byte[] pwk;

    public PinblockHandler(TaskBus bus, byte[] pwk, PinblockRequest request, int comleteLen, int timeout, Logger log) {
        this.bus = bus;
        this.request = request;
        this.comleteLen = comleteLen;
        this.timeout = timeout;
        this.log = log;
        this.listener = request.getListener();
        this.pwk = pwk;
    }

    private void notifyError(int error) {
        this.bus.addTask((Runnable)new ErrorRunner(error));
    }

    private void notifySpec(int key) {
        this.bus.addTask((Runnable)new KeyPressRunner(key));
    }

    private void notifyPinblock(byte[] pb) {
        this.bus.addTask((Runnable)new PinBlockRunner(pb));
    }

    private void notifyKeys(byte[] data) {
        if (data == null || data.length == 0 || this.listener == null) {
            return;
        }
        for (byte b2 : data) {
            char c = (char)b2;
            if (Character.isDigit(c)) {
                this.listener.onPressKey('*');
                continue;
            }
            if (c == '.' || c == '\u001b' || c == '\b' || c == ' ' || c == '\n') continue;
            this.log.error((Object)("Unknown character: " + b2 + ", " + c));
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Start pinblock handler");
        this.log.info((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u041f\u0418\u041d:");
        try {
            int counter = this.timeout * 10;
            InputStream is = System.in;
            char[] buf = new char[20];
            int len = 0;
            while (!Thread.currentThread().isInterrupted()) {
                block18: {
                    try {
                        if (is.available() <= 0) break block18;
                        int read = is.read();
                        this.notifyKeys(new byte[]{(byte)(read & 0xFF)});
                        char c = (char)read;
                        if (Character.isDigit(c)) {
                            buf[len++] = c;
                        } else {
                            if (c == '\u001b') {
                                this.notifyError(2);
                                break;
                            }
                            if (c == '\b') {
                                if (len > 0) {
                                    --len;
                                }
                                this.notifySpec(2);
                            } else if (c != ' ' && c == '\n') {
                                if (len > 0) {
                                    String card_pan = this.request.getPan();
                                    int inputcode = Integer.parseInt(new String(buf, 0, len));
                                    String card_pin = Integer.toString(inputcode);
                                    byte[] pan = b.convertFromHex((String)("0000" + card_pan.substring(3, 15)));
                                    String pinBl = String.format("%02d%s", card_pin.length(), card_pin);
                                    StringBuilder sb = new StringBuilder(pinBl);
                                    for (int i = 16 - pinBl.length(); i > 0; --i) {
                                        sb.append('F');
                                    }
                                    pinBl = sb.toString();
                                    byte[] pin = b.convertFromHex((String)pinBl);
                                    byte[] block = b.xor((byte[])pin, (byte[])pan);
                                    try {
                                        if (this.pwk.length == 8) {
                                            this.notifyPinblock(DesHelper.encryptEcb((byte[])block, (byte[])this.pwk));
                                            break;
                                        }
                                        this.notifyPinblock(DesHelper.encryptEdeEcb((byte[])block, (byte[])this.pwk));
                                    }
                                    catch (Exception ex) {
                                        this.log.error((Object)("error:" + ex.getMessage()), (Throwable)ex);
                                        this.notifyError(4);
                                    }
                                    break;
                                }
                                this.notifyError(2);
                            }
                        }
                        break block18;
                    }
                    catch (IOException ex) {
                        this.notifyError(4);
                        this.log.error((Object)("error:" + ex.getMessage()), (Throwable)ex);
                    }
                    break;
                }
                if (this.timeout > 0 && --counter == 0) {
                    this.notifyError(1);
                    break;
                }
                Thread.sleep(100L);
            }
            this.complete = true;
            this.log.info((Object)"Pinblock handler 'process' finish");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    private class PinBlockRunner
    implements Runnable {
        private final byte[] pinblock;

        public PinBlockRunner(byte[] pinblock) {
            this.pinblock = pinblock;
        }

        @Override
        public void run() {
            PinblockHandler.this.listener.onPinblock(this.pinblock);
        }

        public String toString() {
            return "PinBlockRunner{plain=" + this.pinblock + '}';
        }
    }

    private class KeyPressRunner
    implements Runnable {
        private final int key;

        public KeyPressRunner(int key) {
            this.key = key;
        }

        @Override
        public void run() {
            PinblockHandler.this.listener.onPressSpec(this.key);
        }

        public String toString() {
            return "KeyPressRunner{key=" + this.key + '}';
        }
    }

    private class ErrorRunner
    implements Runnable {
        private final int error;

        public ErrorRunner(int error) {
            this.error = error;
        }

        @Override
        public void run() {
            PinblockHandler.this.listener.onError(this.error);
        }

        public String toString() {
            return "ErrorRunner{error=" + this.error + '}';
        }
    }
}

