/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stubconsole.driver.handler;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.dev.epp.EppKeyListener;

public class KeyPressHandler
implements Handler {
    private final EppKeyListener listener;
    private final TaskBus bus;
    private final Logger log;
    private final int timeout;
    private boolean complete;

    public KeyPressHandler(TaskBus bus, EppKeyListener listener, Logger log, int timeout) {
        this.bus = bus;
        this.listener = listener;
        this.log = log;
        this.timeout = timeout;
    }

    private void notifyKeys(byte[] data) {
        if (data == null || data.length == 0 || this.listener == null) {
            return;
        }
        for (byte b2 : data) {
            char c = (char)b2;
            if (Character.isDigit(c)) {
                this.listener.onPressKey(c);
                continue;
            }
            if (c == '.') {
                this.notifySpec(4);
                continue;
            }
            if (b2 == 27) {
                this.notifySpec(1);
                continue;
            }
            if (c == '\b') {
                this.notifySpec(2);
                continue;
            }
            if (c == ' ') {
                this.notifySpec(3);
                continue;
            }
            if (c == '\n') {
                this.notifySpec(0);
                continue;
            }
            this.log.error((Object)("Unknown character: " + b2 + ", " + c));
        }
    }

    private void notifySpec(int key) {
        this.bus.addTask((Runnable)new KeyPressRunner(key));
    }

    @Override
    public void run() {
        try {
            this.log.info((Object)"Start key press handler");
            this.log.info((Object)"Set open mode");
            int counter = this.timeout * 10;
            InputStream is = System.in;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (is.available() > 0) {
                        int read = is.read();
                        this.notifyKeys(new byte[]{(byte)(read & 0xFF)});
                        if (read == 10 || read == 27) {
                            break;
                        }
                    }
                }
                catch (IOException ex) {
                    this.log.error((Object)("error:" + ex.getMessage()), (Throwable)ex);
                }
                if (this.timeout > 0 && --counter == 0) break;
                Thread.sleep(100L);
            }
            this.log.info((Object)"Key press handler done");
            this.complete = true;
            this.log.info((Object)"Key press 'process' finish");
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    private class KeyPressRunner
    implements Runnable {
        private final int key;

        public KeyPressRunner(int key) {
            this.key = key;
        }

        @Override
        public void run() {
            KeyPressHandler.this.listener.onPressSpec(this.key);
        }

        public String toString() {
            return "KeyPressRunner{key=" + this.key + '}';
        }
    }
}

