/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stub.init;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.crypto.CryptoProvider;
import ru.softlogic.crypto.DESCryptoProvider;
import ru.softlogic.crypto.MacCryptoProvider;
import ru.softlogic.hdw.InitException;
import ru.softlogic.hdw.dev.epp.KeyNotFoundException;
import ru.softlogic.hdw.dev.epp.KeyTag;
import ru.softlogic.hdw.dev.epp.UIDStore;
import ru.softlogic.hdw.dev.epp.init.BaseInitializator;
import ru.softlogic.hdw.dev.epp.init.ManualKeyInApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.utils.PropertiesStorage;
import ru.softlogic.utils.PropertiesStorageImpl;

public class Initializator
extends BaseInitializator {
    private PropertiesStorage stor;
    private final Logger log;
    private File propFile;
    private static final String PIN_MASTER_KEY = "PMK";
    private static final String MAC_MASTER_KEY = "MMK";
    private static final String ENC_MASTER_KEY = "EMK";
    private static final String PIN_WORK_KEY = "PWK";
    private static final String MAC_WORK_KEY = "MAC";
    private static final String ENC_WORK_KEY = "EWK";
    CryptoProvider pinCP;
    MacCryptoProvider macCP;
    MacCryptoProvider encCP;

    public Initializator(SerialPort port, UIDStore store, Locale locale, Logger log) {
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.log = log;
        String filename = System.getProperty("epp.stub.keys.path");
        this.propFile = new File(filename);
        try {
            this.stor = new PropertiesStorageImpl(this.propFile);
        }
        catch (IOException ex) {
            throw new NullPointerException("epp-stub-device prop file not found");
        }
        Properties p = this.stor.getProperties();
        this.pinCP = new DESCryptoProvider(this.stor, PIN_MASTER_KEY, PIN_WORK_KEY);
        this.macCP = new DESCryptoProvider(this.stor, MAC_MASTER_KEY, MAC_WORK_KEY);
        this.encCP = new DESCryptoProvider(this.stor, ENC_MASTER_KEY, ENC_WORK_KEY);
        try {
            this.pinCP.open();
            this.macCP.open();
            this.encCP.open();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public String getInfo() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f:\n");
        sb.append("    \u0424\u0430\u0439\u043b \u043a\u043b\u044e\u0447\u0435\u0439: ").append(this.propFile.getAbsolutePath()).append("\n");
        sb.append("\n");
        sb.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043b\u044e\u0447\u0430\u0445:\n");
        for (Map.Entry<Object, Object> p : this.stor.getProperties().entrySet()) {
            sb.append("    ").append(p.getKey()).append(": ").append(p.getValue()).append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public void clear() throws IOException, InitException {
        this.log.info((Object)"Clear device");
        this.stor.getProperties().clear();
        this.stor.store();
    }

    public void loadUid() throws IOException, InitException {
    }

    private boolean keyExist(byte[] key) {
        return key != null && key.length != 0;
    }

    private boolean keyValid(byte[] key) {
        return key == null || key.length > 0 && key.length % 8 == 0;
    }

    private boolean compareKeys(byte[] key1, byte[] key2) {
        if (key1 == null || key2 == null) {
            return true;
        }
        return key1.length == key2.length;
    }

    private byte[] getKcv(KeyTag keyTag, boolean master) throws KeyNotFoundException, IOException {
        try {
            byte[] res = null;
            switch (keyTag) {
                case PinKey: {
                    res = master ? this.pinCP.getMasterKeyKCV() : this.pinCP.getKeyKCV();
                    break;
                }
                case MacKey: {
                    res = master ? this.macCP.getMasterKeyKCV() : this.macCP.getKeyKCV();
                    break;
                }
                case EncryptKey: {
                    byte[] byArray = res = master ? this.encCP.getMasterKeyKCV() : this.encCP.getKeyKCV();
                }
            }
            if (res != null && res.length > 0) {
                return Arrays.copyOfRange(res, 0, 3);
            }
            throw new KeyNotFoundException(keyTag.name());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public byte[] getKcv(int id) throws IOException, InitException {
        try {
            byte[] res;
            switch (id) {
                case 0: {
                    res = this.getKcv(KeyTag.PinKey, true);
                    break;
                }
                case 1: {
                    res = this.getKcv(KeyTag.MacKey, true);
                    break;
                }
                case 2: {
                    res = this.getKcv(KeyTag.EncryptKey, true);
                    break;
                }
                case 3: {
                    res = this.getKcv(KeyTag.PinKey, false);
                    break;
                }
                case 4: {
                    res = this.getKcv(KeyTag.MacKey, false);
                    break;
                }
                case 5: {
                    res = this.getKcv(KeyTag.EncryptKey, false);
                    break;
                }
                default: {
                    throw new KeyNotFoundException("Key " + id + " not found");
                }
            }
            byte[] byArray = res;
            return byArray;
        }
        catch (KeyNotFoundException ex) {
            throw new InitException(ex.getMessage());
        }
    }

    public byte[] loadMasterKey(KeyTag keyTag, byte[] setPart, byte[] xorPart, boolean overwrite) throws IOException, InitException {
        if (!this.keyExist(setPart) && !this.keyExist(xorPart)) {
            throw new InitException("\u041d\u0438 \u043e\u0434\u043d\u0430 \u0438\u0437 \u0447\u0430\u0441\u0442\u0435\u0439 \u043a\u043b\u044e\u0447\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430");
        }
        if (!this.keyValid(setPart)) {
            throw new InitException("\u0427\u0430\u0441\u0442\u044c 'set' \u043d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u0430");
        }
        if (!this.keyValid(xorPart)) {
            throw new InitException("\u0427\u0430\u0441\u0442\u044c 'xor' \u043d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u0430");
        }
        if (!this.compareKeys(setPart, xorPart)) {
            throw new InitException("\u0414\u043b\u0438\u043d\u0430 \u043a\u043b\u044e\u0447\u0435\u0439 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442");
        }
        try {
            switch (keyTag) {
                case PinKey: {
                    this.pinCP.setMasterKey(setPart, xorPart);
                    return this.pinCP.getMasterKeyKCV();
                }
                case MacKey: {
                    this.macCP.setMasterKey(setPart, xorPart);
                    return this.macCP.getMasterKeyKCV();
                }
                case EncryptKey: {
                    this.encCP.setMasterKey(setPart, xorPart);
                    return this.encCP.getMasterKeyKCV();
                }
            }
        }
        catch (Exception e) {
            throw new InitException((Throwable)e);
        }
        return null;
    }

    public byte[] loadWorkKey(KeyTag keyTag, byte[] keyCryptogram) throws IOException, InitException {
        if (keyCryptogram == null) {
            throw new InitException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u044e\u0447");
        }
        try {
            switch (keyTag) {
                case PinKey: {
                    this.pinCP.setWorkingKey(keyCryptogram);
                    return this.pinCP.getKeyKCV();
                }
                case MacKey: {
                    this.macCP.setWorkingKey(keyCryptogram);
                    return this.macCP.getKeyKCV();
                }
                case EncryptKey: {
                    this.encCP.setWorkingKey(keyCryptogram);
                    return this.encCP.getKeyKCV();
                }
            }
        }
        catch (Exception e) {
            throw new InitException((Throwable)e);
        }
        return null;
    }

    public ManualKeyInApi getManualKeyInApi() {
        return null;
    }
}

