/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.epp.stub.driver.handler;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.epp.stub.driver.handler.BaseHandler;
import ru.softlogic.hardware.epp.stub.driver.handler.Handler;
import ru.softlogic.hardware.epp.stub.driver.handler.StubApp;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.dev.epp.EppPlainPinListener;
import ru.softlogic.hdw.dev.epp.PlainPinRequest;

public class FXPlainPinHandler
extends BaseHandler
implements Handler {
    private final TaskBus bus;
    private final int comleteLen;
    private final Logger log;
    private final EppPlainPinListener listener;
    private final StubApp stubApp;

    public FXPlainPinHandler(TaskBus bus, PlainPinRequest request, int comleteLen, int timeout, Logger log, StubApp stubApp) {
        super(timeout);
        this.bus = bus;
        this.comleteLen = comleteLen;
        this.log = log;
        this.listener = request.getListener();
        this.stubApp = stubApp;
    }

    private void notifyError(int error) {
        this.bus.addTask((Runnable)new ErrorRunner(error));
    }

    private void notifySpec(int key) {
        this.bus.addTask((Runnable)new KeyPressRunner(key));
    }

    private void notifyPlain(String plain) {
        this.bus.addTask((Runnable)new PlainRunner(plain));
    }

    @Override
    public void run() {
        this.stubApp.showApp();
        this.stubApp.setListener(new StubApp.ButtonEvent(){
            char[] buf = new char[20];
            int len = 0;

            @Override
            public void onButton(String id) {
                switch (id) {
                    case "0": 
                    case "1": 
                    case "2": 
                    case "3": 
                    case "4": 
                    case "5": 
                    case "6": 
                    case "7": 
                    case "8": 
                    case "9": {
                        FXPlainPinHandler.this.reset();
                        FXPlainPinHandler.this.listener.onPressKey('*');
                        this.buf[this.len++] = id.charAt(0);
                        if (FXPlainPinHandler.this.comleteLen <= 0 || this.len != FXPlainPinHandler.this.comleteLen) break;
                        FXPlainPinHandler.this.notifyPlain(new String(this.buf, 0, this.len));
                        FXPlainPinHandler.this.finish();
                        break;
                    }
                    case "CORRECT": {
                        if (this.len > 0) {
                            --this.len;
                        }
                        FXPlainPinHandler.this.notifySpec(2);
                        FXPlainPinHandler.this.reset();
                        break;
                    }
                    case "CONFIRM": {
                        if (this.len > 0) {
                            FXPlainPinHandler.this.notifyPlain(new String(this.buf, 0, this.len));
                        } else {
                            FXPlainPinHandler.this.notifyError(2);
                        }
                        FXPlainPinHandler.this.finish();
                        break;
                    }
                    case "CANCEL": {
                        FXPlainPinHandler.this.notifyError(2);
                        FXPlainPinHandler.this.finish();
                    }
                }
            }
        });
        this.log.info((Object)"Start open pin handler");
        this.wait(new Runnable(){

            @Override
            public void run() {
                FXPlainPinHandler.this.notifyError(1);
            }
        });
        this.log.info((Object)"Open pin handler 'process' finish");
        this.stubApp.setListener(null);
        this.stubApp.hideApp();
    }

    private class PlainRunner
    implements Runnable {
        private final String plain;

        public PlainRunner(String plain) {
            this.plain = plain;
        }

        @Override
        public void run() {
            FXPlainPinHandler.this.listener.onPlainPin(this.plain);
        }

        public String toString() {
            return "PlainRunner{plain=" + this.plain + '}';
        }
    }

    private class KeyPressRunner
    implements Runnable {
        private final int key;

        public KeyPressRunner(int key) {
            this.key = key;
        }

        @Override
        public void run() {
            FXPlainPinHandler.this.listener.onPressSpec(this.key);
        }

        public String toString() {
            return "KeyPressRunner{key=" + this.key + '}';
        }
    }

    private class ErrorRunner
    implements Runnable {
        private final int error;

        public ErrorRunner(int error) {
            this.error = error;
        }

        @Override
        public void run() {
            FXPlainPinHandler.this.listener.onError(this.error);
        }

        public String toString() {
            return "ErrorRunner{error=" + this.error + '}';
        }
    }
}

