/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.crd.stub.driver;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.softlogic.hardware.crd.stub.driver.CardInfo;

public class TrackReader {
    public static final String CARDS = "cards";
    public static final String CARD = "card";
    public static final String NAME = "name";
    public static final String TRACK = "track";
    public static final String NUMBER = "number";
    public static final String SELECTED = "selected";

    public static List<CardInfo> readXML(String xml) {
        ArrayList<CardInfo> cards = new ArrayList<CardInfo>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(xml);
            Element doc = dom.getDocumentElement();
            NodeList nl = doc.getElementsByTagName(CARD);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element cel = (Element)nl.item(i);
                String name = cel.getAttribute(NAME);
                NodeList tl = cel.getElementsByTagName(TRACK);
                String[] tracks = new String[]{"", "", ""};
                for (int t = 0; t < tl.getLength(); ++t) {
                    Element trel = (Element)tl.item(t);
                    String textContent = trel.getTextContent();
                    try {
                        String numb = trel.getAttribute(NUMBER);
                        int number = Integer.parseInt(numb);
                        if (number <= 0 || number >= 4) continue;
                        tracks[number - 1] = textContent;
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                CardInfo ci = new CardInfo(name, tracks[0], tracks[1], tracks[2]);
                cards.add(ci);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return cards;
    }

    public static int readXMLSelected(String xml) {
        int res = 0;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(xml);
            Element doc = dom.getDocumentElement();
            try {
                String numb = doc.getAttribute(SELECTED);
                int number = Integer.parseInt(numb);
                if (number > 0) {
                    res = number;
                }
            }
            catch (NumberFormatException ex) {}
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return res;
    }

    public static void saveToXML(String xml, List<CardInfo> cards, int selected) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            Element rootEle = dom.createElement(CARDS);
            rootEle.setAttribute(SELECTED, Integer.toString(selected));
            for (int i = 0; i < cards.size(); ++i) {
                CardInfo card = cards.get(i);
                Element el = dom.createElement(CARD);
                el.setAttribute(NAME, card.getName());
                Element tr1 = dom.createElement(TRACK);
                Element tr2 = dom.createElement(TRACK);
                Element tr3 = dom.createElement(TRACK);
                tr1.setAttribute(NUMBER, "1");
                tr2.setAttribute(NUMBER, "2");
                tr3.setAttribute(NUMBER, "3");
                tr1.appendChild(dom.createTextNode(card.getTrack1()));
                tr2.appendChild(dom.createTextNode(card.getTrack2()));
                tr3.appendChild(dom.createTextNode(card.getTrack3()));
                el.appendChild(tr1);
                el.appendChild(tr2);
                el.appendChild(tr3);
                rootEle.appendChild(el);
            }
            dom.appendChild(rootEle);
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                tr.transform(new DOMSource(dom), new StreamResult(new FileOutputStream(xml)));
            }
            catch (IOException | TransformerException te) {
                System.out.println(te.getMessage());
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println("UsersXML: Error trying to instantiate DocumentBuilder " + pce);
        }
    }
}

