/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.manual.driver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;
import ru.softlogic.hdw.dev.cashacc.DriverControl;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends BaseCashAcceptorDriver {
    private static final String DRIVER_VERSION = "2.1.0";
    private final DriverControl control;
    private int timeout;
    private long lastAction;
    private String key;
    private Denomination[] units;
    private DeviceInfo deviceInfo;
    private final Logger log;
    private final String currency;
    private final BlockingQueue<Runnable> tasks;

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, log);
        this.log = log;
        this.currency = currency;
        this.control = new LocalDriverControl();
        this.tasks = new LinkedBlockingQueue<Runnable>();
    }

    public void _run() throws InterruptedException {
        this.log.info((Object)"Thread start");
        this.key = System.getProperty("cashin-stub-key");
        HashSet<Denomination> dens = new HashSet<Denomination>();
        try {
            dens.addAll(Arrays.asList(Cash.getCashProfile((String)this.currency).getBills()));
            dens.addAll(Arrays.asList(Cash.getCashProfile((String)"EUR").getBills()));
            dens.addAll(Arrays.asList(Cash.getCashProfile((String)"USD").getBills()));
            dens.addAll(Arrays.asList(Cash.getCashProfile((String)"RUB").getBills()));
            dens.addAll(Arrays.asList(Cash.getCashProfile((String)"UAH").getBills()));
        }
        catch (CashProfileException ex) {
            this.log.error((Object)"Error on get cash profile", (Throwable)ex);
        }
        DeviceInfo di = this.createDeviceInfo("Stub", "Stub", DRIVER_VERSION, dens);
        this.updateDeviceInfo(di);
        this.updateState(0);
        try {
            while (!Thread.currentThread().isInterrupted()) {
                Runnable r = this.tasks.take();
                r.run();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Thread stop");
    }

    public DriverControl getDriverControl() {
        return this.control;
    }

    public void enable(CashInOperation operation) {
        try {
            this.log.info((Object)("Load bill table for currency: " + operation.getCurrency()));
            this.units = Cash.getCashProfile((String)operation.getCurrency()).getBills();
        }
        catch (CashProfileException ex) {
            this.log.error((Object)"Can't create units", (Throwable)ex);
            this.units = null;
        }
        super.enable(operation);
    }

    private synchronized boolean canProcess() {
        long now = System.currentTimeMillis();
        if (now - this.lastAction >= (long)(this.timeout * 1000)) {
            this.lastAction = now;
            return true;
        }
        return false;
    }

    private void addCash(int id, boolean protect) {
        if (this.isEnabled()) {
            if (this.canProcess()) {
                Denomination cu = this.getUnitById(id);
                if (cu != null) {
                    if (this.canStack(cu)) {
                        if (!protect) {
                            if ("dYksJPW8GVLu762Zldyp".equals(this.key)) {
                                this.stack(cu);
                            } else {
                                this.log.info((Object)"Key is not set");
                            }
                        } else {
                            Denomination vcu = new Denomination(-cu.getId(), 0, cu.getNominal(), cu.getCurrency());
                            this.stack(vcu);
                        }
                    } else {
                        this.log.info((Object)"Cash is not permit");
                    }
                } else {
                    this.log.error((Object)"Cash unit is not found");
                }
            } else {
                this.log.info((Object)"Can't process");
            }
        } else {
            this.log.info((Object)"Cash acceptor is not enabled");
        }
    }

    private Denomination getUnitById(int id) {
        if (id >= 0 && id < 4 && this.units != null) {
            return this.units[id];
        }
        return null;
    }

    protected long getNormalAccTimeout() {
        return 0L;
    }

    private class SetStateTask
    implements Runnable {
        private final int[] states;

        public SetStateTask(int ... states) {
            this.states = states;
        }

        @Override
        public void run() {
            if (Driver.this.canProcess()) {
                for (int state : this.states) {
                    Driver.this.updateState(state);
                }
            } else {
                Driver.this.log.error((Object)"Can't process");
            }
        }
    }

    private class AddFraudCashTask
    extends AddCashTask {
        public AddFraudCashTask(int id, boolean protect) {
            super(id, protect);
        }

        @Override
        public void run() {
            super.run();
            Driver.this.notifyFraud(0);
        }
    }

    private class AddCashTask
    implements Runnable {
        private final int id;
        private final boolean protect;

        public AddCashTask(int id, boolean protect) {
            this.id = id;
            this.protect = protect;
        }

        @Override
        public void run() {
            Driver.this.addCash(this.id, this.protect);
        }
    }

    private class LocalDriverControl
    implements DriverControl {
        private LocalDriverControl() {
        }

        public void onNote(int id) {
            Driver.this.log.info((Object)("On note: " + id));
            Driver.this.tasks.add(new AddCashTask(id, false));
            Driver.this.notifyEvent(7);
        }

        public void onFroudNote(int id) {
            Driver.this.log.info((Object)("On fraud note: " + id));
            Driver.this.tasks.add(new AddFraudCashTask(id, true));
            Driver.this.notifyEvent(7);
        }

        public void onProtectedNote(int id) {
            Driver.this.log.info((Object)("On protected note: " + id));
            Driver.this.tasks.add(new AddCashTask(id, true));
            Driver.this.notifyEvent(7);
        }

        public void onStackOut() {
            Driver.this.log.info((Object)"On stack out");
            Driver.this.tasks.add(new SetStateTask(2, 0));
        }

        public void onJamm() {
            Driver.this.log.info((Object)"On jamm");
            Driver.this.tasks.add(new SetStateTask(4));
        }

        public void onRecover() {
            Driver.this.log.info((Object)"On recover");
            Driver.this.tasks.add(new SetStateTask(0));
        }
    }
}

