/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.essp;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hdw.proto.essp.IncompleteSum;
import ru.softlogic.hdw.proto.essp.SSPUtils;
import ru.softlogic.hdw.proto.essp.StateListener;
import ru.softlogic.hdw.proto.essp.m;
import ru.softlogic.io.utils.BU;

public class StateHandler {
    private final StateListener listener;
    private final Logger log;
    private final int proto;
    private byte[] last;

    public StateHandler(StateListener listener, int proto, Logger log) {
        if (listener == null) {
            throw new NullPointerException("StateListener");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.listener = listener;
        this.proto = proto;
        this.log = log;
    }

    public void process(byte[] data) {
        this.log.info((Object)("Result: " + BU.toString((byte[])data)));
        if (data == null || data.length == 0) {
            return;
        }
        if (Arrays.equals(data, this.last)) {
            return;
        }
        this.last = data;
        block42: for (int i = 0; i < data.length; ++i) {
            switch (BU.c((byte)data[i])) {
                case 241: {
                    this.log.info((Object)"Slave reset");
                    this.listener.onSlaveReset();
                    continue block42;
                }
                case 239: {
                    int channel = BU.c((byte)data[++i]);
                    this.log.info((Object)("Read: " + channel));
                    this.listener.onRead(channel);
                    continue block42;
                }
                case 238: {
                    int channel = BU.c((byte)data[++i]);
                    this.log.info((Object)("Credit: " + channel));
                    this.listener.onCredit(channel);
                    continue block42;
                }
                case 237: {
                    this.log.info((Object)"Rejecting");
                    this.listener.onRejecting();
                    continue block42;
                }
                case 236: {
                    this.log.info((Object)"Rejected");
                    this.listener.onRejected();
                    continue block42;
                }
                case 204: {
                    this.log.info((Object)"Stacking");
                    this.listener.onStacking();
                    continue block42;
                }
                case 235: {
                    this.log.info((Object)"Stacked");
                    this.listener.onStacked();
                    continue block42;
                }
                case 234: {
                    this.log.info((Object)"Safe jam");
                    this.listener.onSafeJam();
                    continue block42;
                }
                case 233: {
                    this.log.info((Object)"Unsafe jam");
                    this.listener.onUnsafeJam();
                    continue block42;
                }
                case 232: {
                    this.log.info((Object)"Disabled");
                    this.listener.onDisabled();
                    continue block42;
                }
                case 230: {
                    int channel = BU.c((byte)data[++i]);
                    this.log.info((Object)("Fraud: " + channel));
                    this.listener.onFraudAttempt(channel);
                    continue block42;
                }
                case 231: {
                    this.log.info((Object)"Stacker full");
                    this.listener.onStackerFull();
                    continue block42;
                }
                case 225: {
                    int channel = BU.c((byte)data[++i]);
                    this.log.info((Object)"Note cleared front");
                    this.listener.onNoteClearedFront(channel);
                    continue block42;
                }
                case 226: {
                    int channel = BU.c((byte)data[++i]);
                    this.log.info((Object)"Note cleared box");
                    this.listener.onNoteClearedBox(channel);
                    continue block42;
                }
                case 227: {
                    this.log.info((Object)"Box removed");
                    this.listener.onBoxRemoved();
                    continue block42;
                }
                case 228: {
                    this.log.info((Object)"Box replaced");
                    this.listener.onBoxReplaced();
                    continue block42;
                }
                case 209: {
                    this.log.info((Object)"Bar Code Ticket Acknowledge");
                    continue block42;
                }
                case 224: {
                    this.log.info((Object)"Note path open");
                    continue block42;
                }
                case 181: {
                    this.log.info((Object)"Channel Disable");
                    continue block42;
                }
                case 218: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Dispensing " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onDispensing(sums);
                    continue block42;
                }
                case 210: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Dispensed " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onDispensed(sums);
                    continue block42;
                }
                case 213: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Jammed " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onJammed(sums);
                    continue block42;
                }
                case 214: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Halted " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onHalted(sums);
                    continue block42;
                }
                case 215: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Floating " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onFloating(sums);
                    continue block42;
                }
                case 216: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Floated " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onFloated(sums);
                    continue block42;
                }
                case 217: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Timeout " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onTimeout(sums);
                    continue block42;
                }
                case 220: {
                    List<IncompleteSum> sums = SSPUtils.convertToSums(data, i);
                    this.log.info((Object)("Incomplete Payout " + sums));
                    i += 12 * data[i + 1] + 1;
                    this.listener.onIncompletePayout(sums);
                    continue block42;
                }
                case 221: {
                    List<IncompleteSum> sums = SSPUtils.convertToSums(data, i);
                    this.log.info((Object)("Incomplete float " + sums));
                    i += 12 * data[i + 1] + 1;
                    this.listener.onIncompleteFloat(sums);
                    continue block42;
                }
                case 194: {
                    this.log.info((Object)"Emptying");
                    this.listener.onEmpting();
                    continue block42;
                }
                case 195: {
                    this.log.info((Object)"Empted");
                    this.listener.onEmpted();
                    continue block42;
                }
                case 219: {
                    this.log.info((Object)"Note stored in payout");
                    this.listener.onStoredInPayout();
                    continue block42;
                }
                case 179: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Smart empting " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onSmartEmpting(sums);
                    continue block42;
                }
                case 180: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("SMART Emptied " + sums));
                    i += 7 * data[i + 1] + 1;
                    this.listener.onSmartEmptied(sums);
                    continue block42;
                }
                case 129: {
                    this.log.info((Object)"Lid open");
                    continue block42;
                }
                case 130: {
                    this.log.info((Object)"Lid closed");
                    continue block42;
                }
                case 131: {
                    this.log.info((Object)("Calibration fail, cause: " + m.getCalibrationCause(data[i + 1])));
                    ++i;
                    this.listener.onCalibrationFault();
                    continue block42;
                }
                case 222: {
                    List<Sum> sums = SSPUtils.convertToSums(data, i, this.proto);
                    this.log.info((Object)("Cashbox paid " + sums));
                    i += 7 * data[i + 1] + 1;
                    continue block42;
                }
                case 223: {
                    this.log.info((Object)("Coin creadit " + SSPUtils.convertToCoin(data, i)));
                    i += 7;
                    continue block42;
                }
                case 196: {
                    this.log.info((Object)"Coin mechanism jammed");
                    continue block42;
                }
                case 197: {
                    this.log.info((Object)"Coin mechanism return active");
                    continue block42;
                }
                default: {
                    this.log.info((Object)("Unknown state: " + BU.toHex((byte)data[i])));
                    this.listener.onUnknownState(BU.c((byte)data[i]));
                }
            }
        }
    }
}

