/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.cctalk.cvr;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.proto.cctalk.CoreApi;
import ru.softlogic.hdw.proto.cctalk.cvr.BufferedCredit;
import ru.softlogic.hdw.proto.cctalk.cvr.EventPair;
import ru.softlogic.hdw.proto.cctalk.cvr.PoolingPriority;
import ru.softlogic.hdw.proto.cctalk.cvr.SelfCheckState;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class CoinAcceptorApi
extends CoreApi {
    public CoinAcceptorApi(SerialPort port, Logger log) {
        super(port, 2, log);
    }

    public CoinAcceptorApi(SerialPort port, int dest, Logger log) {
        super(port, dest, log);
    }

    public int requestStatus() throws IOException {
        byte[] data = this.conn.sendMessage(248);
        return BU.c((byte)data[0]);
    }

    public PoolingPriority requestPoolingPriority() throws IOException {
        byte[] data = this.conn.sendMessage(249);
        return new PoolingPriority(BU.c((byte)data[0]), BU.c((byte)data[1]));
    }

    public int requestDatabaseVersion() throws IOException {
        byte[] data = this.conn.sendMessage(243);
        return BU.c((byte)data[0]);
    }

    public void testSolenoids(int bitmask) throws IOException {
        this.conn.sendMessage(240, this.conv(bitmask));
    }

    public void testOutputLines(int bitmask) throws IOException {
        this.conn.sendMessage(238, this.conv(bitmask));
    }

    public byte[] readInputLines() throws IOException {
        return this.conn.sendMessage(237, true);
    }

    public int readOptoStates() throws IOException {
        return BU.c((byte)this.conn.sendMessage(236)[0]);
    }

    public void modifyInhibitStatus(int mask) throws IOException {
        this.conn.sendMessage(231, new byte[]{(byte)(mask & 0xFF), (byte)(mask >> 8 & 0xFF)});
    }

    public int requestInhibitStatus() throws IOException {
        byte[] data = this.conn.sendMessage(230);
        return BU.csle((byte[])data, (int)0);
    }

    public void latchOutputLines(int bitmask) throws IOException {
        this.conn.sendMessage(233, this.conv(bitmask));
    }

    public SelfCheckState performSelfCheck() throws IOException {
        byte[] data = this.conn.sendMessage(232);
        return new SelfCheckState(BU.c((byte)data[0]), data.length > 1 ? Integer.valueOf(BU.c((byte)data[1])) : null);
    }

    public BufferedCredit readBufferedCredit() throws IOException {
        byte[] data = this.conn.sendMessage(229);
        EventPair[] eps = new EventPair[5];
        for (int i = 0; i < 5; ++i) {
            EventPair ep;
            eps[i] = ep = new EventPair(data[i * 2 + 1] & 0xFF, data[i * 2 + 2] & 0xFF);
        }
        return new BufferedCredit(BU.c((byte)data[0]), eps);
    }

    public void modifyMasterInhibitStatus(int mask) throws IOException {
        this.conn.sendMessage(228, this.conv(mask));
    }

    public int requestMasterInhibitStatus() throws IOException {
        byte[] data = this.conn.sendMessage(227);
        return data[0];
    }

    public Integer requestInsertionCounter() throws IOException {
        byte[] data = this.conn.sendMessage(226, true);
        if (data != null) {
            return BU.c((byte)data[0]) + (data[1] >> 8) + (data[2] >> 16);
        }
        return null;
    }

    public Integer requestAcceptCounter() throws IOException {
        byte[] data = this.conn.sendMessage(225, true);
        if (data != null) {
            return BU.c((byte)data[0]) + (data[1] >> 8) + (data[2] >> 16);
        }
        return null;
    }

    public Integer requestRejectCounter() throws IOException {
        byte[] data = this.conn.sendMessage(194, true);
        if (data != null) {
            return BU.c((byte)data[0]) + (BU.c((byte)data[1]) >> 8) + (BU.c((byte)data[2]) >> 16);
        }
        return null;
    }

    public Integer requestFraudCounter() throws IOException {
        byte[] data = this.conn.sendMessage(193, true);
        if (data != null) {
            return BU.c((byte)data[0]) + (BU.c((byte)data[1]) >> 8) + (BU.c((byte)data[2]) >> 16);
        }
        return null;
    }

    public void modifySorterOverrideStatus(int mask) throws IOException {
        this.conn.sendMessage(222, this.conv(mask));
    }

    public int requestSorterOverrideStatus() throws IOException {
        return BU.c((byte)this.conn.sendMessage(221)[0]);
    }

    public void setAcceptLimit(int limit) throws IOException {
        this.conn.sendMessage(135, this.conv(limit));
    }

    public int requestSorterPaths(int position) throws IOException {
        byte[] res = this.conn.sendMessage(209, this.conv(position));
        return BU.c((byte)res[0]);
    }

    public void modifySorterPaths(int position, int path) throws IOException {
        this.conn.sendMessage(210, this.conv(position, path));
    }

    public int requestDefaultSorterPath() throws IOException {
        byte[] res = this.conn.sendMessage(188);
        return BU.c((byte)res[0]);
    }

    public void modifyDefaultSorterPath(int path) throws IOException {
        this.conn.sendMessage(189, this.conv(path));
    }

    public Integer requestSecuritySettings(int coinId) throws IOException {
        byte[] res = this.conn.sendMessage(180, this.conv(coinId), true, null, null);
        if (res != null) {
            return BU.c((byte)res[0]);
        }
        return null;
    }

    public int modifySecuritySettings(int coinId, int settings) throws IOException {
        byte[] res = this.conn.sendMessage(181, this.conv(coinId, settings));
        return BU.c((byte)res[0]);
    }

    public String requestCoinId(int position) throws IOException {
        byte[] data = this.conn.sendMessage(184, this.conv(position));
        try {
            String res = new String(data);
            if ("......".equals(res)) {
                return null;
            }
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Integer requestThermistorReading() throws IOException {
        byte[] res = this.conn.sendMessage(173, true);
        if (res != null) {
            return BU.c((byte)res[0]);
        }
        return null;
    }
}

