/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.proto.cctalk;

import java.io.IOException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.proto.cctalk.Connection;
import ru.softlogic.hdw.proto.cctalk.CorePlusApi;
import ru.softlogic.hdw.proto.cctalk.cvr.EventPair;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class CoreApi {
    protected final SerialPort port;
    protected final Logger log;
    private final int dest;
    protected final Connection conn;
    private final CorePlusApi corePlusApi;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(CoreApi.class.getPackage().getName() + ".messages");

    public CoreApi(SerialPort port, int dest, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.port = port;
        this.log = log;
        this.dest = dest;
        this.conn = new Connection(port, dest, log);
        this.corePlusApi = new CorePlusApi(this.conn, log);
    }

    public void open() throws IOException {
        this.port.open();
        this.conn.setDestinationId(this.dest);
    }

    public boolean searchDestination() throws IOException {
        try {
            this.conn.setParams(1, 350);
            this.simplePoll();
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            this.conn.setDestinationId(0);
            this.simplePoll();
            boolean bl = true;
            return bl;
        }
        finally {
            this.conn.resetParams();
        }
    }

    public void close() {
        this.port.close();
    }

    public void simplePoll() throws IOException {
        this.conn.sendMessage(254);
    }

    public byte[] addressPoll() throws IOException {
        return this.conn.sendSimpleMessage(253);
    }

    public String requestManufacterId() throws IOException {
        byte[] data = this.conn.sendMessage(246);
        return new String(data);
    }

    public String requestEquipmentCategoryId() throws IOException {
        byte[] data = this.conn.sendMessage(245);
        return new String(data);
    }

    public String requestProductCode() throws IOException {
        byte[] data = this.conn.sendMessage(244);
        return new String(data);
    }

    public String requestBuildCode() throws IOException {
        byte[] data = this.conn.sendMessage(192);
        return new String(data);
    }

    public CorePlusApi getCorePlusApi() {
        return this.corePlusApi;
    }

    public byte[] readDataBlock(int blockNo) throws IOException {
        return this.conn.sendMessage(215, this.conv(blockNo));
    }

    protected byte[] conv(int param) {
        return new byte[]{BU.c((int)param)};
    }

    protected byte[] conv(int param1, int param2) {
        return new byte[]{BU.c((int)param1), BU.c((int)param2)};
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getEventInfo(EventPair ep) {
        try {
            return bundle.getString("coin.error." + ep.getB());
        }
        catch (Throwable ex) {
            return "Unknown status " + ep;
        }
    }

    public String stateAsStr(int state) {
        try {
            return bundle.getString("state." + state);
        }
        catch (Throwable ex) {
            return "Unknown state " + state;
        }
    }

    public int getNominal(String nominal) {
        if (nominal == null) {
            throw new NullPointerException("Nominal is null");
        }
        if (nominal.length() != 3) {
            throw new IllegalArgumentException("Nominal must be 3 characters");
        }
        if (nominal.matches("\\d{3}")) {
            return Integer.parseInt(nominal);
        }
        int coef = 0;
        if (nominal.contains("K")) {
            coef = 1000;
        } else if (nominal.contains("M")) {
            coef = 1000000;
        }
        String[] paths = nominal.split("K|M");
        int i1 = 0;
        if (paths[0].length() > 0) {
            i1 = Integer.parseInt(paths[0]);
        }
        int i2 = 0;
        if (paths[1].length() > 0) {
            i2 = Integer.parseInt(paths[1]);
        }
        return i1 * coef + i2 * coef / 10;
    }
}

