/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.vkp80;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.CustomBdInfoExtractor;
import ru.softlogic.hardware.pos.CustomBdStateExctractor;
import ru.softlogic.hardware.pos.CustomBdStatisticExtractor;
import ru.softlogic.hardware.pos.InfoExtractor;
import ru.softlogic.hardware.pos.StateExtractor;
import ru.softlogic.hardware.pos.StatisticExtractor;
import ru.softlogic.hardware.pos.generic.BaseApi;
import ru.softlogic.hdw.dev.printer.pos.ImageApi;
import ru.softlogic.hdw.dev.printer.pos.InfoApi;
import ru.softlogic.hdw.dev.printer.pos.LoadFontApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.SecurityApi;
import ru.softlogic.hdw.dev.printer.pos.StatisticApi;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.io.utils.BU;

public class Api
extends BaseApi
implements InfoApi,
StatisticApi,
LoadFontApi,
SecurityApi {
    protected BidirectionPort port;
    protected final Logger log;
    private final StatisticExtractor statExtr;
    private final InfoExtractor infoExtr;
    private final StateExtractor stateExtr;
    private Boolean useSecurity;

    public Api(SerialPort port, PosPrtOptions options, Logger log) {
        this((BidirectionPort)port, options, "vkp80", log);
    }

    public Api(UsbPort port, PosPrtOptions options, Logger log) {
        this((BidirectionPort)port, options, "vkp80", log);
    }

    public Api(BidirectionPort port, PosPrtOptions options, String prnId, Logger log) {
        super(port, options, prnId, log);
        this.port = port;
        this.log = log;
        this.statExtr = new CustomBdStatisticExtractor(port);
        this.infoExtr = new CustomBdInfoExtractor(port);
        this.stateExtr = new CustomBdStateExctractor(port, log);
    }

    public PosPrinterState getStatus() throws IOException {
        return this.stateExtr.getState();
    }

    @Override
    public InfoApi getInfoApi() {
        return this;
    }

    @Override
    public ImageApi getImageApi() {
        return this;
    }

    @Override
    public StatisticApi getStatisticApi() {
        return this;
    }

    @Override
    public LoadFontApi getLoadFontApi() {
        return this;
    }

    public String getVendor() throws IOException {
        return "Custom";
    }

    public int getModelId() throws IOException {
        return this.infoExtr.getModelId();
    }

    public String getModel() throws IOException {
        return this.infoExtr.getModel();
    }

    public String getFirmware() throws IOException {
        return this.infoExtr.getFirmware();
    }

    public String getPrintedLength() throws IOException {
        return this.statExtr.getPrintedLength();
    }

    public String getCutsNumber() throws IOException {
        return this.statExtr.getCutsNumber();
    }

    public String getRetrackingNumber() throws IOException {
        return this.statExtr.getRetrackingNumber();
    }

    public String getPowerUpNumber() throws IOException {
        return this.statExtr.getPowerUpNumber();
    }

    public void load(int width, int hight, byte character, byte[] bitMap) throws IOException {
        byte[] command = new byte[6 + hight / 8 * width];
        command[0] = 27;
        command[1] = 38;
        command[2] = (byte)(hight / 8);
        command[3] = character;
        command[4] = character;
        command[5] = (byte)width;
        System.arraycopy(bitMap, 0, command, 6, bitMap.length);
        this.port.write(command);
    }

    private boolean checkSecurity() {
        try {
            this.log.info((Object)"send req");
            this.port.write(new byte[]{28, 36, 82});
            byte[] res = this.port.read(4);
            this.log.info((Object)("<<" + BU.toString((byte[])res)));
            res = this.formAns(res);
            this.log.info((Object)(">>" + BU.toString((byte[])res)));
            this.port.write(res);
            this.log.info((Object)("<<" + BU.toString((byte[])this.port.read(1))));
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private byte[] formAns(byte[] in) {
        byte[] res = new byte[]{28, 36, 87, BU.c((int)(in[1] & in[3] | in[2] ^ 0xFF)), BU.c((int)(in[0] & 0x4B ^ in[3])), BU.c((int)((in[2] ^ in[1]) & 0xB4)), BU.c((int)(in[3] ^ in[0] | 0x4B))};
        return res;
    }

    @Override
    public SecurityApi getSecurityApi() {
        if (this.useSecurity == null) {
            this.useSecurity = this.checkSecurity();
        }
        return this.useSecurity != false ? this : null;
    }

    public void process() {
        this.checkSecurity();
    }
}

