/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.tup900;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.CommonBdStateExctractor;
import ru.softlogic.hardware.pos.StateExtractor;
import ru.softlogic.hardware.pos.generic.BaseApi;
import ru.softlogic.hdw.dev.printer.pos.ImageApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;

public class Api
extends BaseApi {
    protected final BidirectionPort port;
    protected final Logger log;
    private final StateExtractor stateExtractor;

    public Api(SerialPort port, PosPrtOptions options, Logger log) {
        this((BidirectionPort)port, options, "tup900", log);
    }

    public Api(UsbPort port, PosPrtOptions options, Logger log) {
        this((BidirectionPort)port, options, "tup900", log);
    }

    public Api(BidirectionPort port, PosPrtOptions options, String prnId, Logger log) {
        super(port, options, prnId, log);
        this.port = port;
        this.log = log;
        this.stateExtractor = new CommonBdStateExctractor(port, log);
        port.setTimeout(2000);
    }

    public PosPrinterState getStatus() throws IOException {
        return this.stateExtractor.getState();
    }

    @Override
    public ImageApi getImageApi() {
        return this;
    }
}

