/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.ttp2000;

import java.io.IOException;
import java.util.HashMap;
import ru.softlogic.hardware.pos.ttp2000.ZebraDeviceId;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.utils.BU;

public class ZebraApi {
    private BidirectionPort port;

    public ZebraApi(BidirectionPort port) {
        this.port = port;
    }

    public ZebraDeviceId getDeviceId() throws IOException {
        this.port.write(new byte[]{27, 5, 99});
        int len = BU.c((byte)this.port.read(2)[1]);
        String result = new String(this.port.read(len - 2));
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kv : result.split(";")) {
            String[] r = kv.split(":");
            if (r.length != 2) continue;
            params.put(r[0].trim(), r[1].trim());
        }
        return new ZebraDeviceId((String)params.get("MANUFACTURER"), (String)params.get("MODEL"));
    }

    public String getFirmware() throws IOException {
        this.port.write(new byte[]{27, 5, 7});
        byte[] res = this.port.read(2);
        return BU.c((byte)res[0]) + "." + BU.c((byte)res[1]);
    }

    public long getSerialNumber() throws IOException {
        this.port.write(new byte[]{27, 5, 9});
        byte[] res = this.port.read(6);
        return BU.clbe((byte[])res, (int)0, (int)6);
    }
}

