/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.ttp2000;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.StateExtractor;
import ru.softlogic.hardware.pos.generic.BaseApi;
import ru.softlogic.hardware.pos.ttp2000.ZebraApi;
import ru.softlogic.hardware.pos.ttp2000.ZebraStateExtractor;
import ru.softlogic.hdw.dev.printer.pos.InfoApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.io.utils.BU;

public class Api
extends BaseApi
implements InfoApi {
    private BidirectionPort port;
    private StateExtractor se;
    private ZebraApi zapi;

    public Api(SerialPort port, PosPrtOptions options, Logger log) {
        this((BidirectionPort)port, options, "ttp2000", log);
    }

    public Api(UsbPort port, PosPrtOptions options, Logger log) {
        this((BidirectionPort)port, options, "ttp2000", log);
    }

    public Api(BidirectionPort port, PosPrtOptions options, String type, Logger log) {
        super(port, options, type, log);
        this.port = port;
        this.se = new ZebraStateExtractor(port, log);
        this.zapi = new ZebraApi(port);
    }

    @Override
    public void print(String text) throws IOException {
        super.print(text);
        this.port.write(new byte[]{27, 112});
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.port.write("\n".getBytes());
        }
    }

    @Override
    public void eject(int steps) throws IOException {
        this.port.write(new byte[]{27, 12, BU.c((int)steps)});
        this.port.write(new byte[]{27, 112});
    }

    public PosPrinterState getStatus() throws IOException {
        return this.se.getState();
    }

    @Override
    public InfoApi getInfoApi() {
        return this;
    }

    public int getModelId() throws IOException {
        return 0;
    }

    public String getVendor() throws IOException {
        return this.zapi.getDeviceId().getManufacturer();
    }

    public String getModel() throws IOException {
        return this.zapi.getDeviceId().getModel();
    }

    public String getFirmware() throws IOException {
        return this.zapi.getFirmware();
    }
}

