/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.tg2480h;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.pos.BarcodeApi;
import ru.softlogic.hdw.dev.printer.pos.EscPosUtils;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.SecurityApi;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.io.utils.BU;

public class Api
extends ru.softlogic.hardware.pos.vkp80.Api
implements BarcodeApi {
    public Api(SerialPort port, PosPrtOptions options, Logger log) {
        super((BidirectionPort)port, options, "tg2480h", log);
    }

    public Api(UsbPort port, PosPrtOptions options, Logger log) {
        super((BidirectionPort)port, options, "tg2480h", log);
    }

    @Override
    public void _loadImage(File path) throws IOException, WrongImageException, InterruptedException {
        this.log.info((Object)("Load image: " + path));
        this.loadImage(path, 0);
    }

    @Override
    public void _printImage(File path, int size) throws IOException, WrongImageException, InterruptedException {
        this.log.info((Object)("Print image: " + path));
        this.loadImage(path, 1);
        this.port.write(new byte[]{29, 112, 1, BU.c((int)size)});
        Thread.sleep(1000L);
    }

    @Override
    public BarcodeApi getBarcodeApi() {
        return this;
    }

    @Override
    public SecurityApi getSecurityApi() {
        return null;
    }

    public int getSupportedTypes() {
        return 1;
    }

    public void printBarocode(String data) throws IOException {
        EscPosUtils.printQR((Port)this.port, (String)data);
    }

    private void loadImage(File path, int bankNo) throws IOException, InterruptedException {
        EscPosUtils.loadBmpImage((Port)this.port, (File)path, (int)bankNo, (Logger)this.log);
    }
}

