/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.generic.search;

import java.io.IOException;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hardware.search.UsbSearchable;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.io.utils.BU;

public class Searchable
extends BaseSearchable
implements UsbSearchable {
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        try {
            port.open();
            port.flush(Flush.RxTx);
            port.setTimeout(300);
            DeviceDescription deviceDescription = this.getDescription((BidirectionPort)port);
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            port.close();
        }
    }

    public DeviceDescription search(UsbPort port) throws NotFoundException {
        try {
            port.open();
            port.setTimeout(20);
            DeviceDescription deviceDescription = this.getDescription((BidirectionPort)port);
            return deviceDescription;
        }
        catch (IOException ex) {
            throw new NotFoundException("Not found", (Throwable)ex);
        }
        finally {
            port.close();
        }
    }

    public SerialParams[] getSearchParams(int priority) {
        if (priority == 0) {
            return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
        }
        if (priority == 1) {
            return new SerialParams[]{new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None)};
        }
        if (priority == 2) {
            return new SerialParams[]{new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
        }
        if (priority == 3) {
            return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.Even), new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.Even)};
        }
        if (priority == 4) {
            return new SerialParams[]{new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.Mark)};
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 49;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 1);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }

    public UsbSearchable getUsbSearchable() {
        return this;
    }

    public String identity(UsbPort port) {
        return "n/a";
    }

    private int getModelId(BidirectionPort port) throws IOException {
        byte[] bytes;
        port.write(new byte[]{29, 73, 1});
        int oneByte = port.readByte();
        if (oneByte == 93) {
            port.write(new byte[]{29, 73, 5});
            byte[] sx = port.tryRead(2);
            if (sx != null && sx.length == 2 && sx[0] == 2 && sx[1] == 25) {
                return 537;
            }
        }
        if ((oneByte & 0xFF) == 255) {
            port.write(new byte[]{29, 73, -1});
            bytes = port.read(2);
            return bytes[0] << 8 | BU.c((byte)bytes[1]);
        }
        if ((oneByte & 0xFF) == 117) {
            port.write(new byte[]{29, 73, 67});
            bytes = port.tryRead(20);
            String name = new String(bytes);
            if (name.contains("PPU-7")) {
                return -1;
            }
        }
        return oneByte;
    }

    private DeviceDescription getDescription(BidirectionPort port) throws IOException, NotFoundException {
        int modelId = this.getModelId(port);
        switch (modelId) {
            case 93: 
            case 94: {
                return this.createDescriptor("pos", "vkp80");
            }
            case 147: {
                return this.createDescriptor("pos", "tg2480");
            }
            case 168: {
                return this.createDescriptor("pos", "tg2480h");
            }
            case 95: {
                return this.createDescriptor("pos", "snbct080");
            }
            case 517: {
                return this.createDescriptor("pos", "vkp80_3");
            }
            case 537: {
                return this.createDescriptor("pos", "vkp80sx");
            }
            case 81: {
                return this.createDescriptor("pos", "cts2000");
            }
            case 48: {
                return this.createDescriptor("pos", "cbm1000");
            }
            case -1: 
            case 19: {
                return this.createDescriptor("pos", "ppu700");
            }
            case 39: {
                return this.createDescriptor("pos", "tup900");
            }
        }
        throw new NotFoundException("Not found: " + BU.toHex((int)modelId));
    }
}

