/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos.generic;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.io.WriteListener;

class DumpListener
implements WriteListener {
    private static final int SIZE = 32;
    private final Logger log;
    private final List<Byte> bytes = new LinkedList<Byte>();

    public DumpListener(Logger log) {
        this.log = log;
    }

    public void onWrite(byte ... data) {
        if (this.bytes.isEmpty()) {
            this.log.info((Object)"Start i/o dump");
        }
        for (byte b : data) {
            this.bytes.add(b);
        }
    }

    public void reset() {
        this.bytes.clear();
    }

    public void dump() {
        this.log.info((Object)"Write data:");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (byte b : this.bytes) {
            if (i > 0 && i % 32 == 0) {
                this.log.info((Object)sb);
                sb = new StringBuilder();
            }
            sb.append(String.format("%02X ", b));
            ++i;
        }
        if (sb.length() > 0) {
            this.log.info((Object)sb);
        }
    }

    public static String toString(List<Byte> data) {
        if (data == null) {
            return "";
        }
        String str = "";
        for (byte b : data) {
            str = str + String.format("%02X ", b);
        }
        return str;
    }
}

