/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.pos;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.pos.StateExtractor;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.utils.BU;

public class CustomBdStateExctractor
implements StateExtractor {
    private final BidirectionPort port;
    private final Logger log;

    public CustomBdStateExctractor(BidirectionPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("Port is not set");
        }
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
        this.port = port;
        this.log = log;
    }

    @Override
    public PosPrinterState getState() throws IOException {
        this.port.write(new byte[]{16, 4, 20});
        for (int i = 0; i < 10; ++i) {
            if (this.port.readByte() != 16) continue;
            int second = this.port.readByte();
            if (second == 15) {
                byte[] res = this.port.read(4);
                int state = 0;
                int flags = 0;
                if ((res[0] & 1) > 0) {
                    state = 1;
                }
                if ((res[0] & 4) > 0) {
                    flags |= 1;
                }
                if (state == 0 && ((res[1] & 1) > 0 || (res[1] & 2) > 0)) {
                    state = 2;
                }
                if (state == 0 && (res[2] & 1) > 0) {
                    state = 3;
                }
                if (state == 0 && (res[2] & 1) > 0) {
                    state = 3;
                }
                if (state == 0 && (res[3] & 1) > 0) {
                    state = 5;
                }
                if (state > 0) {
                    this.log.error((Object)("status bytes: " + BU.toString((byte[])res)));
                }
                return new PosPrinterState(state, flags);
            }
            throw new IOException("second byte 0x0f not found, value=" + String.format("0x%02x", second));
        }
        throw new IOException("start byte 0x10 not found");
    }
}

