/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.driver;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.mod.gsm.driver.AtCommandResult;
import ru.softlogic.hardware.mod.gsm.driver.Connector2;
import ru.softlogic.hardware.mod.gsm.driver.Modem;
import ru.softlogic.hardware.mod.gsm.driver.ModemResult;
import ru.softlogic.hardware.mod.gsm.driver.SignalLevel;
import ru.softlogic.io.serial.SerialPort;

public class GenericModemApi2 {
    private static final int TIMEOUT = 2000;
    private Logger log;
    private Connector2 connector;

    public GenericModemApi2(SerialPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.log = log;
        this.connector = new Connector2(port, log);
    }

    public void open() throws IOException {
        this.connector.open();
    }

    public void close() {
        this.connector.close();
    }

    public ModemResult<String> getVendor() throws IOException {
        return this.getStringResult("AT+CGMI");
    }

    public ModemResult<String> getModel() throws IOException {
        return this.getStringResult("AT+CGMM");
    }

    public ModemResult<String> getFirmware() throws IOException {
        return this.getStringResult("AT+CGMR");
    }

    public ModemResult<Long> getImei() throws IOException {
        return this.getLongResult("AT+CGSN");
    }

    public ModemResult<Long> getImsi() throws IOException {
        return this.getLongResult("AT+CIMI");
    }

    public ModemResult reset() throws IOException {
        return this.getVoidResult("ATZ");
    }

    public ModemResult setTextMode() throws IOException {
        return GenericModemApi2.getVoidResult(this.connector.send("+++", 2000, false));
    }

    public ModemResult cancel() throws IOException {
        return this.getVoidResult("ATH");
    }

    public ModemResult<String> getRegistration() throws IOException {
        return this.getStringResult("AT+CREG?");
    }

    public ModemResult<SignalLevel> getSignalLevel() throws IOException {
        AtCommandResult acr = this.connector.send("AT+CSQ", 2000);
        if (acr.getCode() != Modem.ResultCode.Ok) {
            return new ModemResult<SignalLevel>(acr);
        }
        List<Integer> values = GenericModemApi2.getResult(acr.getData(), "+CSQ: ");
        return new ModemResult<SignalLevel>(acr, new SignalLevel(values.get(0), values.get(1)));
    }

    public ModemResult<Modem.ActivityStatus> getActivity() throws IOException {
        AtCommandResult acr = this.connector.send("AT+CPAS", 2000);
        if (acr.getCode() != Modem.ResultCode.Ok) {
            return new ModemResult<Modem.ActivityStatus>(acr);
        }
        int idx = GenericModemApi2.getIntResult(acr.getData(), "+CPAS: ");
        return new ModemResult<Modem.ActivityStatus>(acr, Modem.ActivityStatus.values()[idx]);
    }

    public ModemResult testCommand(String cmd) throws IOException {
        return this.getVoidResult(cmd);
    }

    private static List<Integer> getResult(List<String> data, String prefix) throws IOException {
        if (data.size() != 1) {
            throw new IOException("Wrong answer format, 1 line was expected, but received: " + data);
        }
        String value = data.get(0);
        if (!value.startsWith(prefix)) {
            throw new IOException("Data " + value + " does not start with " + prefix);
        }
        value = value.substring(prefix.length()).trim();
        LinkedList<Integer> res = new LinkedList<Integer>();
        for (String s : value.split(",")) {
            res.add(Integer.parseInt(s));
        }
        return res;
    }

    private static int getIntResult(List<String> data, String prefix) throws IOException {
        List<Integer> res = GenericModemApi2.getResult(data, prefix);
        if (res.isEmpty()) {
            throw new IOException("Wrong answer size");
        }
        return res.get(0);
    }

    private static ModemResult<String> getStringResult(AtCommandResult acr) {
        if (acr.getCode() == Modem.ResultCode.Ok) {
            return new ModemResult<String>(acr, acr.getData().get(0));
        }
        return new ModemResult<String>(acr);
    }

    private ModemResult<String> getStringResult(String cmd) throws IOException {
        return GenericModemApi2.getStringResult(this.connector.send(cmd, 2000));
    }

    private static ModemResult<Long> getLongResult(AtCommandResult acr) {
        if (acr.getCode() == Modem.ResultCode.Ok) {
            return new ModemResult<Long>(acr, Long.parseLong(acr.getData().get(0)));
        }
        return new ModemResult<Long>(acr);
    }

    private ModemResult<Long> getLongResult(String cmd) throws IOException {
        return GenericModemApi2.getLongResult(this.connector.send(cmd, 2000));
    }

    private static ModemResult getVoidResult(AtCommandResult mr) {
        return new ModemResult(mr);
    }

    private ModemResult getVoidResult(String cmd) throws IOException {
        return GenericModemApi2.getVoidResult(this.connector.send(cmd, 2000));
    }
}

