/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.driver;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.mod.gsm.driver.GenericModemApi;
import ru.softlogic.hardware.mod.gsm.driver.ModemHelper;
import ru.softlogic.hdw.dev.modem.Api;
import ru.softlogic.hdw.dev.modem.ModOptions;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.ModemException;
import ru.softlogic.hdw.dev.modem.ModemInfo;
import ru.softlogic.hdw.dev.modem.NetworkInfo;
import ru.softlogic.hdw.dev.modem.NotRegisteredException;
import ru.softlogic.hdw.dev.modem.OpenException;
import ru.softlogic.hdw.dev.modem.Registration;
import ru.softlogic.hdw.dev.modem.SoftwareWatchdog;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public class Driver
implements Modem,
SoftwareWatchdog {
    private final String type;
    private final SerialPort port;
    private final ModOptions options;
    private final Logger log;
    private GenericModemApi api;
    private ModemInfo info;
    private String vendor;

    public Driver(String type, SerialPort port, ModOptions options, Logger log) {
        if (type == null) {
            throw new NullPointerException("Type is not set");
        }
        if (port == null) {
            throw new NullPointerException("SerialPort is not set");
        }
        if (options == null) {
            throw new NullPointerException("ModOptions is not set");
        }
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
        this.type = type;
        this.port = port;
        this.options = options;
        this.log = log;
        this.api = new GenericModemApi(port, log);
    }

    public ModemInfo init() throws IOException {
        try {
            this.reset();
            if (this.info == null) {
                this.log.info((Object)"Get modem info");
                this.vendor = this.api.getVendor();
                this.log.info((Object)("Vendor: " + this.vendor));
                String model = this.api.getModel();
                this.log.info((Object)("Model: " + model));
                String firmare = this.api.getFirmware();
                this.log.info((Object)("Firmvare: " + firmare));
                DeviceInfo di = new DeviceInfo(6, this.type);
                di.setVendor(this.vendor);
                di.setModel(model);
                di.setFirmware(firmare);
                di.setPort(SerialFmt.format((SerialPort)this.port));
                long imei = 0L;
                long imsi = 0L;
                try {
                    imei = this.api.getImei();
                    imsi = this.api.getImsi();
                }
                catch (ModemException ex) {
                    this.log.error((Object)"Can't request IMEI \u0438 IMSI", (Throwable)ex);
                }
                this.info = new ModemInfo(di, imei, imsi);
            }
            return this.info;
        }
        catch (ModemException ex) {
            throw new IOException(ex);
        }
    }

    public NetworkInfo getNetworkInfo() throws IOException, NotRegisteredException {
        try {
            Registration reg = this.checkReg();
            int operId = this.api.getOperatorId();
            this.log.info((Object)("Mncmcc: " + operId));
            String operName = this.api.getOperatorName();
            this.log.info((Object)("Name: " + operName));
            int signal = this.api.getSignalLevel();
            this.log.info((Object)("Signal level: " + signal));
            Integer balance = null;
            if (this.options.isCheckBalance()) {
                this.log.info((Object)"Check balance");
                String ussd = this.options.getUssd();
                if (ussd == null || ussd.isEmpty()) {
                    this.log.info((Object)("USSD request is not set, get request for operator " + operId));
                    ussd = ModemHelper.getUssdRequest(operId, operName);
                }
                this.log.info((Object)("USSD request: " + ussd));
                if (ussd != null && !ussd.isEmpty()) {
                    if (this.vendor == null) {
                        this.vendor = this.api.getVendor();
                    }
                    if ((balance = this.getBalance(this.api, ussd, this.vendor)) == null) {
                        this.log.info((Object)"Try another variant");
                        balance = this.getBalance(this.api, "\"" + ussd + "\"", this.vendor);
                    }
                    this.log.info((Object)("Result: " + balance));
                } else {
                    this.log.error((Object)"Unknown ussd request");
                }
            }
            return new NetworkInfo(reg.getLac(), reg.getCid(), operId, operName, signal, balance);
        }
        catch (ModemException ex) {
            throw new IOException(ex);
        }
    }

    public SoftwareWatchdog getSoftwareWatchdog() {
        return this;
    }

    public void resetModem() throws IOException {
        try {
            if (this.api.rebootGprsModule(ModemHelper.getPowerOffRequest(this.vendor))) {
                this.log.info((Object)"succsess");
            } else {
                this.log.info((Object)"error");
            }
        }
        catch (ModemException ex) {
            throw new IOException(ex);
        }
    }

    private void reset() throws ModemException {
        this.api.setTextMode();
        this.api.configure();
        this.api.cancel();
        this.api.reset();
    }

    private Integer getBalance(Api modemApi, String ussd, String vendor) {
        Pattern balancePattern = Pattern.compile("\\-?[0-9]+");
        Integer result = null;
        try {
            this.log.info((Object)("Check balance, ussd=" + ussd));
            String balance = modemApi.executeUssd(ussd, ModemHelper.isPDURequire(vendor));
            this.log.info((Object)("Balance: " + balance));
            balance = balance.toLowerCase();
            String[] mins = ModemHelper.getMinusPrefixes();
            if (mins != null && mins.length > 0) {
                for (String minus : mins) {
                    if (!balance.contains(minus)) continue;
                    this.log.info((Object)("Process minus: " + minus));
                    balance = balance.replace(minus, "-");
                    break;
                }
            }
            this.log.info((Object)("Result: " + balance));
            Matcher balanceMatcher = balancePattern.matcher(balance);
            if (balanceMatcher.find()) {
                result = Integer.parseInt(balanceMatcher.group());
            }
        }
        catch (NumberFormatException | ModemException ex) {
            this.log.error((Object)"Can't check balance", ex);
        }
        return result;
    }

    public void open() throws OpenException {
        try {
            this.api.open();
        }
        catch (IOException ex) {
            throw new OpenException("Error on open port", (Throwable)ex);
        }
    }

    public void close() {
        this.api.close();
    }

    public int getSignalLevel() throws IOException, NotRegisteredException {
        try {
            this.reset();
            this.checkReg();
            return this.api.getSignalLevel();
        }
        catch (ModemException ex) {
            throw new IOException(ex);
        }
    }

    private Registration checkReg() throws ModemException, NotRegisteredException {
        this.api.setRegistrationMode(2);
        Registration reg = this.api.getRegistration();
        if (reg.getState() != 1 && reg.getState() != 5) {
            throw new NotRegisteredException("Modem is not registered in network, current state=" + reg.getState());
        }
        return reg;
    }

    public Api getApi() {
        return this.api;
    }

    public ModOptions getModemOptions() {
        return this.options;
    }
}

