/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm.driver;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.mod.gsm.driver.AtCommandResult;
import ru.softlogic.hardware.mod.gsm.driver.Modem;
import ru.softlogic.io.StopStorageEx;
import ru.softlogic.io.Storage;
import ru.softlogic.io.WrongTypePortException;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

public class Connector2 {
    private static final List<byte[]> STOPS = new LinkedList<byte[]>();
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final byte CTRL_Z = 26;
    private final SerialPort port;
    private final Logger log;

    public Connector2(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("SerialPort is null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Logger is null");
        }
        this.port = port;
        this.log = log;
    }

    public void open() throws WrongTypePortException, IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
    }

    public void close() {
        this.port.close();
    }

    public AtCommandResult send(String cmd, int timeout) throws IOException {
        return this.send(cmd, '\r', timeout, true);
    }

    public AtCommandResult send(String cmd, int timeout, boolean getAnswer) throws IOException {
        return this.send(cmd, '\r', timeout, getAnswer);
    }

    public AtCommandResult send(String cmd, char end, int timeout, boolean getAnswer) throws IOException {
        LinkedList<String> data = new LinkedList<String>();
        LinkedList<String> extData = new LinkedList<String>();
        try {
            String line;
            String lcCmd = cmd.toLowerCase(Locale.US);
            String cmd1 = lcCmd + end;
            this.log.debug((Object)(">>" + lcCmd));
            this.port.flush(Flush.RxTx);
            this.port.setTimeout(timeout);
            this.port.write(cmd1.getBytes());
            Thread.sleep(40L);
            if (!getAnswer) {
                return null;
            }
            while ((line = this.readLine(256)) != null) {
                if (lcCmd.equals(line) || line.isEmpty()) continue;
                if (line.startsWith("^")) {
                    extData.add(line);
                    continue;
                }
                data.add(line);
                if (!Connector2.isResult(line)) continue;
            }
            this.log.debug((Object)("<<" + data));
            Thread.sleep(20L);
            return Connector2.getResult(cmd, data, extData);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
    }

    private static AtCommandResult getResult(String atCommand, List<String> data, List<String> extData) {
        String rc = data.remove(data.size() - 1);
        if ("OK".equals(rc)) {
            return new AtCommandResult(atCommand, Modem.ResultCode.Ok, data, extData);
        }
        if ("ERROR".equals(rc)) {
            return new AtCommandResult(atCommand, Modem.ResultCode.Error, data, extData);
        }
        if ("NO CARRIER".equals(rc)) {
            return new AtCommandResult(atCommand, Modem.ResultCode.NoCarrier, data, extData);
        }
        if ("BUSY".equals(rc)) {
            return new AtCommandResult(atCommand, Modem.ResultCode.Busy, data, extData);
        }
        if ("NO DIALTONE".equals(rc)) {
            return new AtCommandResult(atCommand, Modem.ResultCode.NoDialtone, data, extData);
        }
        if (rc.startsWith("+CME ERROR: ")) {
            return new AtCommandResult(atCommand, Modem.ResultCode.CmeError, Integer.parseInt(rc.substring(13)), data, extData);
        }
        return null;
    }

    private static boolean isResult(String line) {
        return line.matches("(OK|ERROR|NO CARRIER|BUSY|NO DIALTONE|\\+CME ERROR: \\d+)");
    }

    private synchronized String readLine(int deep) throws IOException {
        return new String(this.port.read((Storage)new StopStorageEx(STOPS, deep))).trim();
    }

    static {
        STOPS.add("\r\n".getBytes());
        STOPS.add("> ".getBytes());
    }
}

