/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public class GsmUtils {
    private GsmUtils() {
    }

    public static String encodePDU(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            int c;
            int t = i % 8 + 1;
            if (t == 8) continue;
            int oc = c = str.charAt(i) >> i % 8;
            int b = 0;
            if (i < str.length() - 1) {
                b = str.charAt(i + 1) & (1 << t) - 1;
            }
            c = b << 8 - t | c;
            sb.append(String.format("%02x", c));
        }
        return sb.toString();
    }

    public static String decodePDU(String str) {
        if (str == null) {
            return null;
        }
        int d = 0;
        int b = 0;
        LinkedList<Byte> data = new LinkedList<Byte>();
        for (int i = 0; i < str.length() / 2; ++i) {
            int bt = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16) & 0xFF;
            int c = (bt & (1 << 7 - d) - 1) << d | b;
            b = bt >> 7 - d;
            data.add((byte)c);
            if (++d != 7) continue;
            data.add((byte)b);
            d = 0;
            b = 0;
        }
        byte[] res = new byte[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            res[i] = (Byte)data.get(i);
        }
        try {
            return new String(res, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public static String decodePDUtoHex(String str) {
        if (str == null) {
            return null;
        }
        int d = 0;
        int b = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length() / 2; ++i) {
            int bt = Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16) & 0xFF;
            int c = (bt & (1 << 7 - d) - 1) << d | b;
            b = bt >> 7 - d;
            sb.append(String.format("%02X", c));
            if (++d != 7) continue;
            sb.append(String.format("%02X", b));
            d = 0;
            b = 0;
        }
        return sb.toString();
    }

    public static byte[] ucs2Encode(String hexString) throws NumberFormatException {
        int length = hexString.length();
        byte[] buffer = new byte[(length + 1) / 2];
        boolean evenByte = true;
        byte nextByte = 0;
        int bufferOffset = 0;
        if (length % 2 == 1) {
            evenByte = false;
        }
        for (int i = 0; i < length; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = (byte)(nibble << 4);
            } else {
                nextByte = (byte)(nextByte + (byte)nibble);
                buffer[bufferOffset++] = nextByte;
            }
            evenByte = !evenByte;
        }
        return buffer;
    }
}

