/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.mod.gsm;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.ModemException;
import ru.softlogic.io.WrongTypePortException;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connector {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final byte CTRL_Z = 26;
    private final SerialPort port;
    private final Logger log;

    public Connector(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("SerialPort is null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Logger is null");
        }
        this.port = port;
        this.log = log;
    }

    public void open() throws WrongTypePortException, IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
    }

    public void close() {
        this.port.close();
    }

    public synchronized List<String> send(String cmd, int timeout) throws ModemException {
        return this.send(cmd, '\r', timeout, true);
    }

    public synchronized List<String> send(String cmd, int timeout, boolean getAnswer) throws ModemException {
        return this.send(cmd, '\r', timeout, getAnswer);
    }

    public synchronized List<String> send(String cmd, char end, int timeout, boolean getAnswer) throws ModemException {
        LinkedList<String> res = new LinkedList<String>();
        try {
            String data;
            String lcCmd = cmd.toLowerCase(Locale.US);
            String cmd1 = lcCmd + end;
            this.log.debug((Object)(">>" + lcCmd));
            this.port.flush(Flush.RxTx);
            this.port.setTimeout(timeout);
            this.port.write(cmd1.getBytes("UTF-8"));
            Thread.sleep(40L);
            if (!getAnswer) {
                return null;
            }
            while ((data = this.readLine(timeout)) != null) {
                if (lcCmd.equals(data)) {
                    this.log.debug((Object)"echo present");
                    continue;
                }
                if ("".equals(data)) {
                    this.log.debug((Object)"void str");
                    continue;
                }
                res.add(data);
                if (!data.matches("(OK|ERROR|NO CARRIER|BUSY|NO DIALTONE)")) continue;
            }
            this.log.debug((Object)("<<" + res));
            Thread.sleep(20L);
            return res;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ModemException((Throwable)ex);
        }
        catch (IOException ex) {
            if (!res.isEmpty()) {
                return res;
            }
            throw new ModemException((Throwable)ex);
        }
    }

    public synchronized List<String> sendUssd(String cmd, char end, int timeout) throws ModemException {
        LinkedList<String> res = new LinkedList<String>();
        try {
            String data;
            String lcCmd = cmd.toLowerCase(Locale.US);
            String cmd1 = lcCmd + end;
            this.port.flush(Flush.RxTx);
            this.port.setTimeout(timeout);
            this.log.debug((Object)(">>" + cmd1));
            this.port.write(cmd1.getBytes("UTF-8"));
            while ((data = this.readLine(timeout)) != null) {
                if (lcCmd.equals(data)) {
                    this.log.debug((Object)"echo present");
                    continue;
                }
                if ("".equals(data)) {
                    this.log.debug((Object)"void str");
                    continue;
                }
                if (data.startsWith("^")) {
                    this.log.info((Object)("Skip " + data));
                    continue;
                }
                res.add(data);
                if (data.matches("OK")) {
                    this.log.info((Object)"Success, read data");
                    continue;
                }
                if (data.matches("(ERROR|NO CARRIER|BUSY|NO DIALTONE)")) {
                    this.log.error((Object)("Error, exit[" + data + "]"));
                    break;
                }
                if (!data.startsWith("+CUSD:")) continue;
                this.log.info((Object)"USSD answer was read. Exit");
                break;
            }
            this.log.info((Object)("<<" + res));
            Thread.sleep(20L);
            return res;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ModemException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new ModemException((Throwable)ex);
        }
    }

    public synchronized List<String> sendSms(String cmd, String msg, int timeout) throws ModemException {
        LinkedList<String> res = new LinkedList<String>();
        try {
            String data;
            String cmdFull = "AT+CMGS=" + cmd.toLowerCase(Locale.US) + '\r';
            this.log.debug((Object)("Command: " + cmdFull));
            this.port.setTimeout(timeout);
            this.port.write(cmdFull.getBytes("UTF-8"));
            while ((data = this.readLine(timeout)) != null) {
                if (cmdFull.equals(data)) {
                    this.log.debug((Object)"echo present");
                    continue;
                }
                this.log.info((Object)("new data: " + data));
                res.add(data);
                if (data.matches("(OK|ERROR|NO CARRIER|BUSY|NO DIALTONE)")) {
                    this.log.error((Object)"Exit");
                    break;
                }
                if (!data.startsWith(">")) continue;
                this.log.error((Object)"Send text");
                msg = msg + '\r';
                this.port.write(msg.getBytes("UTF-8"));
                this.port.write((byte)26);
            }
            return res;
        }
        catch (IOException ex) {
            throw new ModemException((Throwable)ex);
        }
    }

    private synchronized String readLine(int timeout) throws IOException {
        LinkedList<Byte> res;
        block1: {
            long start = System.currentTimeMillis();
            res = new LinkedList<Byte>();
            do {
                byte[] r = this.port.read(1);
                res.add(r[0]);
                this.log.debug((Object)BU.toString(res));
                int sz = res.size();
                if (sz >= 2 && ((Byte)res.get(sz - 2) == 13 && (Byte)res.get(sz - 1) == 10 || (Byte)res.get(sz - 2) == 62 && (Byte)res.get(sz - 1) == 32)) break block1;
                if (res.size() <= 400) continue;
                throw new IOException("Too long");
            } while (System.currentTimeMillis() - start <= (long)timeout);
            throw new IOException("Too slow");
        }
        String str = new String(BU.convert(res)).trim();
        this.log.debug((Object)("<<" + str));
        return str;
    }
}

