/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.cvr.cctalk.driver;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.proto.cctalk.cvr.BufferedCredit;
import ru.softlogic.hdw.proto.cctalk.cvr.CoinAcceptorApi;
import ru.softlogic.hdw.proto.cctalk.cvr.EventPair;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Driver
extends BaseCashAcceptorDriver {
    private static final String DRIVER_VERSION = "2.0.1";
    private final CoinAcceptorApi api;
    private final Logger log;
    private Integer lastEvent;
    private final HashMap<Integer, Denomination> units = new HashMap();
    private final Map<Denomination, Integer> masks = new HashMap<Denomination, Integer>();

    public Driver(String type, SerialPort port, String currency, Logger log) {
        super(new DeviceId(4, type, 0), port, currency, log);
        this.api = new CoinAcceptorApi(port, log);
        this.log = log;
    }

    public void reinit() {
        this.updateState(0);
    }

    protected void _run() throws InterruptedException {
        boolean inited = false;
        Boolean lastEnable = null;
        int lastState = -1;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Boolean e;
                int state;
                if (!inited) {
                    this.getCoinInfo();
                    inited = true;
                }
                if (this.lastEvent == null) {
                    this.log.info((Object)"Last event is not set, read data");
                    BufferedCredit bc = this.api.readBufferedCredit();
                    this.lastEvent = bc.getEventsCount();
                    this.log.info((Object)("Last event " + this.lastEvent));
                }
                if ((state = this.api.requestStatus()) != lastState) {
                    this.log.info((Object)("State: " + this.api.stateAsStr(state) + ", " + state));
                    lastState = state;
                    if (state == 0) {
                        this.updateState(0);
                    } else if (state == 2) {
                        this.updateState(14);
                    }
                }
                if (!(e = Boolean.valueOf(this.isEnabled())).equals(lastEnable)) {
                    lastEnable = this.isEnabled();
                    if (e.booleanValue()) {
                        this.log.info((Object)"Enable coin acceptor, modify inhibit status");
                        this.api.modifyInhibitStatus(this.getMask());
                        this.log.info((Object)"Modify master inhibit status");
                        this.api.modifyMasterInhibitStatus(1);
                        this.log.info((Object)"Success");
                        this.notifySafeState(false);
                    } else {
                        this.log.info((Object)"Disable coin acceptor");
                        this.api.modifyInhibitStatus(0);
                        this.log.info((Object)"Disabled, process events");
                        this.sleep(200);
                        this.processEvents();
                        this.log.info((Object)"Done");
                        this.notifySafeState(true);
                    }
                }
                this.processEvents();
                this.processExtChange();
                this.onConnSuccess();
            }
            catch (IOException ex) {
                this.onConnError(ex);
                inited = false;
                this.api.close();
                this.randomSleep(500, 500);
            }
        }
    }

    private void getCoinInfo() throws IOException {
        this.log.info((Object)"Try to open port");
        this.api.open();
        this.api.searchDestination();
        String manufacter = this.api.requestManufacterId();
        this.log.info((Object)("Manufacturer: " + manufacter));
        String product = this.api.requestProductCode();
        this.log.info((Object)("Model: " + product));
        int serial = this.api.getCorePlusApi().requestSerialNumber();
        this.log.info((Object)("Serial number: " + serial));
        String software = this.api.getCorePlusApi().requestSoftwareRevision();
        this.log.info((Object)("Software revision: " + software));
        String catId = this.api.requestEquipmentCategoryId();
        this.log.info((Object)("Category Id: " + catId));
        this.log.info((Object)"Supported coins");
        LinkedHashSet<Denomination> uniques = new LinkedHashSet<Denomination>();
        this.units.clear();
        this.masks.clear();
        for (int i = 1; i <= 16; ++i) {
            try {
                String name = this.api.requestCoinId(i);
                if (name == null) break;
                if ((name = name.trim()).length() == 6 && !name.startsWith("FF")) {
                    String country = name.substring(0, 2);
                    int nominal = this.api.getNominal(name.substring(2, 5));
                    if (nominal > 0) {
                        Denomination den = this.getCoin(country, nominal);
                        this.log.info((Object)("  id=" + i + ", name=" + name + "->" + den));
                        if (den != null) {
                            uniques.add(den);
                            int mask = this.masks.getOrDefault(den, 0);
                            this.masks.put(den, 1 << i - 1 | mask);
                        }
                        this.units.put(i, den);
                        continue;
                    }
                    this.log.info((Object)("  id=" + i + ", name=" + name + "->Skip"));
                    continue;
                }
                this.log.info((Object)("  id=" + i + ", name=" + name + "->Skip"));
                continue;
            }
            catch (IOException ex) {
                this.log.info((Object)("  id=" + i + ", name=<undefined>"));
            }
        }
        DeviceInfo info = this.createDeviceInfo(manufacter, product, DRIVER_VERSION, uniques);
        info.setSerial(Integer.toString(serial));
        info.setFirmware(software);
        this.updateDeviceInfo(info);
        this.log.info((Object)"===");
    }

    private void processEvents() throws IOException {
        BufferedCredit bc = this.api.readBufferedCredit();
        if (bc.getEventsCount() != this.lastEvent.intValue()) {
            int diff = this.getDiff(bc.getEventsCount(), this.lastEvent);
            this.lastEvent = bc.getEventsCount();
            this.log.info((Object)("Events in buffer: " + diff));
            if (diff > 5) {
                this.log.info((Object)("Lost data about " + (diff - 5) + " events"));
                diff = 5;
            }
            EventPair[] pairs = bc.getEvents();
            for (int i = 0; i < diff; ++i) {
                EventPair ep = pairs[i];
                if (ep.getA() > 0 && ep.getA() < 255) {
                    this.log.info((Object)("Sorter path: " + ep.getB()));
                    this.log.info((Object)("Bill type " + ep.getA() + " validated correctly and sent to cashbox"));
                    this.stack(this.units.get(ep.getA()));
                    continue;
                }
                if (ep.getA() == 0) {
                    this.log.info((Object)("Event: " + this.api.getEventInfo(ep) + ", id=" + ep.getB()));
                    switch (ep.getB()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.notifyEvent(1);
                            this.notifyEvent(2);
                            break;
                        }
                        case 6: 
                        case 16: {
                            this.updateState(3);
                            break;
                        }
                        case 7: 
                        case 15: {
                            this.updateState(4);
                            break;
                        }
                        case 11: {
                            this.updateState(2);
                            break;
                        }
                        case 14: {
                            this.updateState(1);
                            break;
                        }
                        case 10: 
                        case 254: {
                            this.updateState(0);
                        }
                    }
                    continue;
                }
                this.log.info((Object)("Unknown event: " + ep));
            }
        }
    }

    private int getDiff(int current, int last) {
        if (current > last) {
            return current - last;
        }
        return current - last + 255;
    }

    private void processExtChange() throws IOException {
        if (this.isKeeperChange()) {
            this.log.info((Object)"Modify mask");
            this.api.modifyInhibitStatus(this.getMask());
            this.log.info((Object)"Done");
        }
    }

    private int getMask() {
        int mask = 0;
        for (Denomination d : this.masks.keySet()) {
            if (!this.canStack(d)) continue;
            mask += this.masks.get(d).intValue();
        }
        this.log.info((Object)("Mask: " + BU.toHex((int)mask)));
        return mask;
    }

    protected long getNormalAccTimeout() {
        return 0L;
    }
}

