/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.tbv100;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.WrongCommandException;
import ru.softlogic.io.StartStorage;
import ru.softlogic.io.Storage;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connector {
    public static final byte CMD_POLL = 17;
    public static final byte CMD_RESET = 64;
    public static final byte CMD_ENABLE = -61;
    public static final byte CMD_DISABLE = -61;
    public static final byte CMD_STACK = 65;
    public static final byte CMD_RETURN = 67;
    public static final byte CMD_IDENTIFICATION = -120;
    public static final byte CMD_BOOT = -119;
    public static final byte CMD_ENABLEBILLTYPES = -64;
    public static final byte CMD_SECURE = -63;
    public static final byte CMD_SETTING_REQ = -117;
    public static final byte PCK_START = -4;
    private static final int MAX_LEN = 20;
    private int attempts = 5;
    private int ioTimeout = 4000;
    private int attemptPause = 300;
    private SerialPort port;
    private Logger log;

    public Connector(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("Port is null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Logger is null");
        }
        this.port = port;
        this.log = log;
    }

    public int getIoTimeout() {
        return this.ioTimeout;
    }

    public void setIoTimeout(int ioTimeout) {
        this.ioTimeout = ioTimeout;
    }

    public void setAttemptPause(int attemptPause) {
        this.attemptPause = attemptPause;
    }

    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
    }

    public void close() {
        this.port.close();
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public final byte[] sendCommand(byte cmd) throws IOException {
        return this.sendCommand(cmd, null);
    }

    public final byte[] sendCommand(byte cmd, byte[] data) throws IOException {
        try {
            return this.sendCommand2(cmd, data);
        }
        catch (WrongCommandException ex) {
            throw new IOException(ex);
        }
    }

    public final byte[] sendCommand2(byte cmd, byte[] data) throws IOException, WrongCommandException {
        IOException lastEx = null;
        byte[] request = this.formMessage(cmd, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.log.debug((Object)"--------------------------------------------");
                this.log.debug((Object)(">> " + BU.toString((byte[])request)));
                this.port.flush(Flush.RxTx);
                this.port.setTimeout(this.ioTimeout);
                this.port.write(request);
                this.port.read((Storage)new StartStorage(-4, 1));
                byte[] rdata = this.port.read(1);
                byte len = rdata[0];
                this.log.debug((Object)("<< \u0434\u043b\u0438\u043d\u0430 \u043e\u0442\u0432\u0435\u0442\u0430: " + BU.toString((byte[])rdata)));
                int l = BU.c((byte)len);
                rdata = this.port.read(l - 2);
                byte[] response = new byte[l];
                response[0] = -4;
                response[1] = len;
                System.arraycopy(rdata, 0, response, 2, len - 2);
                this.log.debug((Object)("<<: " + BU.toString((byte[])response)));
                if (!this.checkCrc16(response)) {
                    Thread.sleep(20L);
                    throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0432\u0445\u043e\u0434\u044f\u0448\u0435\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u043b\u0430");
                }
                if (response[2] == 74) {
                    throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u043b\u0430");
                }
                if (response[2] == 75) {
                    throw new WrongCommandException("Wrong cmd, request: " + BU.toString((byte[])request));
                }
                this.port.write(this.formMessage((byte)80, null));
                byte[] result = new byte[response.length - 4];
                for (int z = 0; z < response.length - 4; ++z) {
                    result[z] = response[z + 2];
                }
                this.log.debug((Object)("<|: " + BU.toString((byte[])result)));
                return result;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.port.close();
                continue;
            }
            catch (IOException e) {
                lastEx = e;
                this.log.error((Object)("Attemp " + i + " error " + e.getMessage()));
                if (i + 1 >= this.attempts) continue;
                try {
                    Thread.sleep(this.attemptPause);
                    this.close();
                    this.open();
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442!", lastEx);
    }

    private byte[] formMessage(byte cmd, byte[] data) {
        int dataLen = 5;
        if (data != null) {
            dataLen = (byte)(dataLen + data.length);
        }
        byte[] request = new byte[dataLen];
        request[0] = -4;
        request[1] = dataLen;
        request[2] = cmd;
        if (data != null) {
            System.arraycopy(data, 0, request, 3, data.length);
        }
        this.signCrc16(request);
        return request;
    }

    private void signCrc16(byte[] data) {
        if (data.length < 2) {
            return;
        }
        int crc = this.makeCrc16(data);
        data[data.length - 2] = (byte)(crc & 0xFF);
        data[data.length - 1] = (byte)(crc >> 8 & 0xFF);
    }

    private boolean checkCrc16(byte[] data) {
        if (data.length < 5) {
            return false;
        }
        int crc = this.makeCrc16(data);
        byte crc1 = (byte)(crc & 0xFF);
        byte crc2 = (byte)(crc >> 8 & 0xFF);
        return data[data.length - 2] == crc1 && data[data.length - 1] == crc2;
    }

    private int makeCrc16(byte[] data) {
        int crc = 0;
        if (data.length < 2) {
            return crc;
        }
        for (int i = 0; i < data.length - 2; ++i) {
            crc ^= 0xFF & data[i];
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) != 0) {
                    crc >>= 1;
                    crc ^= 0x8408;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc;
    }
}

