/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ssp.search;

import java.io.IOException;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.BaseSearchable;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hdw.proto.essp.SSPApi;
import ru.softlogic.hdw.proto.essp.SSPException;
import ru.softlogic.hdw.proto.essp.ValidatorSetup;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class Searchable
extends BaseSearchable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceDescription _search(SerialPort port) throws NotFoundException {
        SSPApi api = new SSPApi(port, 0, this.log);
        api.getConnector().setAttempts(1);
        api.getConnector().setAttemptPause(0);
        api.getConnector().setTimeout(100);
        try {
            api.open();
            api.sync();
            int res = api.getUnitType();
            if (res == this.getType()) {
                DeviceDescription deviceDescription = null;
                return deviceDescription;
            }
            if (res == 3) {
                DeviceDescription deviceDescription = this.createDescriptor("cdm", "smhp");
                return deviceDescription;
            }
            if (res == 6) {
                DeviceDescription deviceDescription = this.createDescriptor("bvr", "smpt");
                return deviceDescription;
            }
            if (res == 0) {
                ValidatorSetup set = api.getValidatorSetup();
                if (set.getProto() == 3) {
                    DeviceDescription deviceDescription = this.createDescriptor("bvr", "ssp");
                    return deviceDescription;
                }
                DeviceDescription deviceDescription = this.createDescriptor("bvr", "itl");
                return deviceDescription;
            }
        }
        catch (IOException | SSPException exception) {
        }
        finally {
            api.close();
        }
        throw new NotFoundException("Not found");
    }

    public SerialParams[] getSearchParams(int priority) {
        if (priority == 0) {
            return new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
        }
        return NO_SERIAL_PARAMS;
    }

    public int getSearchOrder() {
        return 55;
    }

    public boolean canSearch(SerialPort port) {
        return this.canSearch(port, 7);
    }

    public String identity(SerialPort port) {
        return "n/a";
    }

    protected int getType() {
        return 0;
    }
}

