/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ssp.driver;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.proto.essp.Banknote;
import ru.softlogic.hdw.proto.essp.SSPApi;
import ru.softlogic.hdw.proto.essp.SSPException;
import ru.softlogic.hdw.proto.essp.StateAdapter;
import ru.softlogic.hdw.proto.essp.StateHandler;
import ru.softlogic.hdw.proto.essp.ValidatorSetup;
import ru.softlogic.hdw.proto.essp.eSSPException;
import ru.softlogic.hdw.proto.essp.m;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends BaseCashAcceptorDriver {
    private static final String DRIVER_VERSION = "2.0.0";
    private final SerialPort port;
    private final SSPApi api;
    private final Logger log;
    private ValidatorSetup setup;
    private Map<Integer, Denomination> units;
    private static final int PROTO = 6;

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, currency, log);
        this.port = port;
        this.api = new SSPApi(port, 0, log);
        this.log = log;
    }

    protected void _run() throws InterruptedException {
        boolean localEnabled = false;
        StateHandler sh = new StateHandler(new LocalStateListener(), 6, this.log);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                boolean enable;
                if (this.setup == null) {
                    this.init();
                }
                if ((enable = this.isEnabled()) != localEnabled) {
                    if (enable) {
                        this.api.enable();
                        this.api.setChannelInhibits(255);
                    } else {
                        this.api.disable();
                        this.api.setChannelInhibits(0);
                    }
                    localEnabled = enable;
                }
                sh.process(this.api.poll());
                this.sleep(200);
            }
            catch (IOException | SSPException | eSSPException ex) {
                this.onConnError(ex);
                this.setup = null;
                this.api.close();
                this.randomSleep(500, 500);
            }
        }
    }

    private void init() throws IOException, eSSPException, SSPException {
        this.log.info((Object)"Open port");
        this.api.open();
        this.log.info((Object)("Sync: " + m.get(this.api.sync())));
        this.api.setHostProtocol(6);
        int serial = this.api.getSerial();
        this.log.info((Object)("Serial: " + serial));
        String firmware = this.api.getFirmware();
        this.log.info((Object)("Firmware: " + firmware));
        int unitType = this.api.getUnitType();
        this.log.info((Object)("Unit type: " + m.getUnitName(unitType) + ", id=" + unitType));
        this.api.disable();
        this.api.setChannelInhibits(0);
        this.log.info((Object)"Get device setup:");
        this.setup = this.api.getValidatorSetup();
        this.log.info((Object)("   Firmware: " + this.setup.getFirmvare()));
        this.log.info((Object)("   Country: " + this.setup.getMainCountryCode()));
        this.log.info((Object)("   Multiplier: " + this.setup.getMuliplier()));
        this.log.info((Object)("   Proto: " + this.setup.getProto()));
        this.log.info((Object)("   Secures: " + Arrays.toString(this.setup.getSecures())));
        this.log.info((Object)"   Banknotes: ");
        this.units = new HashMap<Integer, Denomination>();
        HashSet<Denomination> den = new HashSet<Denomination>();
        LinkedHashSet<String> uniques = new LinkedHashSet<String>();
        this.api.createEncryptedLayer(SSPApi.ITL_KEY);
        Banknote[] bns = this.setup.getBanknotes();
        for (int i = 0; i < bns.length; ++i) {
            Banknote bn = bns[i];
            uniques.add(bn.getNominal() + bn.getCountry());
            Denomination d = this.getBill(bn.getCountry(), bn.getNominal());
            this.log.info((Object)("      " + bn.toString() + "->" + d));
            this.units.put(i, d);
            if (d != null) {
                den.add(d);
            }
            if (unitType != 6) continue;
            try {
                this.api.setRouting(0, bn);
                continue;
            }
            catch (SSPException ex) {
                this.log.error((Object)("Can't route " + bn + " to cash box"));
            }
        }
        this.api.enablePayoutDevice();
        DeviceInfo di = this.createDeviceInfo("ITL", "SSP", DRIVER_VERSION, den);
        di.setSerial(Integer.toString(serial));
        di.setFirmware(firmware);
        di.setInfo(firmware);
        di.setModel(m.getUnitName(unitType));
        di.setInfo(((Object)uniques).toString());
        this.updateDeviceInfo(di);
        this.log.info((Object)"-------");
    }

    private Denomination get(int channel) {
        return this.units.get(channel - 1);
    }

    private class LocalStateListener
    extends StateAdapter {
        private Denomination unit;

        private LocalStateListener() {
        }

        @Override
        public void onRead(int channel) {
            if (channel == 0) {
                Driver.this.log.info((Object)"Accepting");
                Driver.this.notifyEvent(1);
            } else {
                Driver.this.log.info((Object)("Accepting: " + Driver.this.get(channel)));
            }
        }

        @Override
        public void onCredit(int channel) {
            this.unit = Driver.this.get(channel);
            Driver.this.log.info((Object)("Credit: " + channel + ", unit=" + this.unit));
        }

        @Override
        public void onBoxReplaced() {
            Driver.this.updateState(0);
        }

        @Override
        public void onBoxRemoved() {
            Driver.this.updateState(2);
        }

        @Override
        public void onStackerFull() {
            Driver.this.updateState(1);
        }

        @Override
        public void onSafeJam() {
            Driver.this.updateState(3);
        }

        @Override
        public void onUnsafeJam() {
            Driver.this.updateState(3);
        }

        @Override
        public void onStacked() {
            Driver.this.notifySafeState(true);
            Driver.this.log.info((Object)"Notify cash storage");
            Driver.this.stack(this.unit);
            Driver.this.log.info((Object)("Bill stacked " + this.unit));
            Driver.this.notifyEvent(7);
        }

        @Override
        public void onStoredInPayout() {
            Driver.this.log.info((Object)"Fixme>>>");
            try {
                Driver.this.log.info(Driver.this.api.getAllLevels());
            }
            catch (IOException | SSPException ex) {
                Driver.this.log.info((Object)("Error on load: " + ex.getMessage()));
            }
        }

        @Override
        public void onDisabled() {
        }

        @Override
        public void onRejecting() {
            Driver.this.notifySafeState(true);
        }

        @Override
        public void onRejected() {
            Driver.this.notifyEvent(2);
            try {
                int code = Driver.this.api.getLastRejectCode();
                Driver.this.log.info((Object)("Reject cause: " + m.getRejectError(code)));
            }
            catch (IOException | SSPException ex) {
                Driver.this.log.error((Object)"Error on get reject cause", (Throwable)ex);
            }
        }
    }
}

