/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds.driver;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.ebds.Api;
import ru.softlogic.hardware.bvr.ebds.EbdsVersion;
import ru.softlogic.hdw.Hardware;
import ru.softlogic.hdw.InitException;
import ru.softlogic.hdw.base.UpdateListener;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.StopBits;

public class UpdateTask {
    private static final int STANDART_BLOCK_LENGTH = 32;
    private static final int FAST_BLOCK_LENGTH = 64;
    private static final long STD_FINAL_SLEEP = 60000L;
    private static final long FAST_FINAL_SLEEP = 20000L;
    private static final long FINAL_POLL_SLEEP = 1000L;
    private final byte[] block32 = new byte[32];
    private final byte[] block64 = new byte[64];
    private EbdsVersion version;
    private final SerialParams defParams = new SerialParams(9600, DataBits.Seven, StopBits.One, Parity.Even);
    private final File TMP = new File(Hardware.getFirmwarePath(), "mei-tmp");
    private final Api api;
    private final Logger log;

    public UpdateTask(Api api, Logger log) {
        this.api = api;
        this.log = log;
    }

    public void update(UpdateListener listener) {
        block3: {
            try {
                this.log.info((Object)"-----------------------------------------------------------------------------------------");
                this.log.info((Object)"Start ebds firmware update");
                long t = System.currentTimeMillis();
                this.runImpl();
                this.log.info((Object)"Success");
                if (listener != null) {
                    listener.onSuccess(System.currentTimeMillis() - t);
                }
            }
            catch (IOException | InitException ex) {
                this.log.error((Object)"Erron on update firmware", ex);
                if (listener == null) break block3;
                listener.onError(ex.getMessage());
            }
        }
    }

    public File getNewestAppFile() throws InitException, IOException {
        String fwBase = this.getFirmwareBase();
        String appId = this.api.getAccessorApplicationId();
        File file = this.getNewestFile(fwBase + "-app", this.getVersion(appId));
        this.log.info((Object)("    App version: " + appId + "->" + file));
        return file;
    }

    public File getNewestBillSetFile() throws InitException, IOException {
        String fwBase = this.getFirmwareBase();
        String variantId = this.api.getAccessorVariantId();
        String variantName = this.api.getAccessorVariant();
        File file = this.getNewestFile(fwBase + "-billset-" + variantName.toLowerCase(), this.getVersion(variantId));
        this.log.info((Object)("    Billset version: " + variantId + ", currencies: " + variantName + "->" + file));
        return file;
    }

    private void runImpl() throws IOException, InitException {
        if (this.api.isDownloadMode()) {
            this.speedUp(this.TMP);
        } else {
            this.log.info((Object)("    Firmware path: " + Hardware.getFirmwarePath().getAbsolutePath()));
            File appFw = this.getNewestAppFile();
            File billsetFw = this.getNewestBillSetFile();
            if (appFw != null) {
                this.startUpdate(appFw);
            }
            if (billsetFw != null) {
                this.startUpdate(billsetFw);
            }
            this.log.info((Object)"The device is updated");
        }
    }

    private void startUpdate(File file) throws IOException, InitException {
        this.log.info((Object)"----------------------------");
        FileUtils.copyFile((File)file, (File)this.TMP);
        this.log.info((Object)("Try to start download: " + file.getName()));
        if (!this.api.startDownloadFirmware()) {
            throw new InitException("Can't run update process");
        }
        this.speedUp(this.TMP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void speedUp(File file) throws IOException, InitException {
        this.log.info((Object)"Try to speed up");
        for (int i = 0; i < 3; ++i) {
            this.log.info((Object)("    Try \u2116" + i));
            try {
                this.setFastParams();
                SerialParams sp = this.api.setMaxBaudRate();
                if (sp != null) {
                    this.log.info((Object)("Select fast mode, port params: " + sp));
                    this.api.getPort().setParams(sp);
                    this.fastLoad(file);
                } else {
                    this.log.info((Object)"Device is not support fast mode, standart mode is used ");
                    this.stdLoad(file);
                }
                return;
            }
            catch (IOException | InitException ex) {
                if (i != 2) continue;
                throw ex;
            }
            finally {
                this.setSolidParams();
            }
        }
    }

    private void stdLoad(File file) throws InitException, IOException {
        this.checkFile(file);
        int count = (int)(file.length() / 32L);
        boolean countErrors = false;
        int blockNumber = 0;
        this.log.info((Object)("Block count: " + count));
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            while (blockNumber < count) {
                raf.seek((long)(blockNumber * 32) * 1L);
                raf.read(this.block32, 0, 32);
                int nextBlock = this.api.blockDownloadFirmware(blockNumber, this.block32);
                if (nextBlock != blockNumber + 1) {
                    this.log.error((Object)("Error on block download, next block=" + nextBlock));
                }
                if ((blockNumber = nextBlock) % 40 != 0) continue;
                this.log.info((Object)("Loaded " + blockNumber + "/" + count));
            }
            this.log.info((Object)"Download success. Sleep 60000ms...");
            Thread.sleep(60000L);
            while (this.api.poll().isFlashDownload()) {
                this.log.info((Object)"Wait for normal state");
                Thread.sleep(1000L);
            }
            this.log.info((Object)"Standart load done");
        }
        catch (InterruptedException ex) {
            try {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                this.log.info((Object)("Finish: " + this.api.finishDownloadFirmware()));
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)raf);
        this.log.info((Object)("Finish: " + this.api.finishDownloadFirmware()));
    }

    private void fastLoad(File file) throws InitException, IOException {
        this.checkFile(file);
        boolean shortBlock = file.length() % 64L != 0L;
        int count = (int)(file.length() / 64L + (long)(shortBlock ? 1 : 0));
        int errCount = 0;
        int blockNumber = 0;
        this.log.info((Object)("Block count: " + count));
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            while (blockNumber < count) {
                byte[] data;
                raf.seek((long)(blockNumber * 64) * 1L);
                if (blockNumber == count - 1 && shortBlock) {
                    this.log.info((Object)"Load short block");
                    data = this.block32;
                    raf.read(data, 0, 32);
                } else {
                    data = this.block64;
                    raf.read(data, 0, 64);
                }
                int nextBlock = this.api.fastBlockDownloadFirmware(blockNumber, data);
                if (nextBlock != blockNumber + 1) {
                    ++errCount;
                    this.log.error((Object)("Error on block download, next block=" + nextBlock));
                } else {
                    errCount = 0;
                }
                blockNumber = nextBlock;
                Thread.sleep(5L);
                if (blockNumber % 20 != 0) continue;
                this.log.info((Object)("Loaded " + blockNumber + "/" + count));
            }
            this.api.getPort().setParams(this.defParams);
            this.log.info((Object)"Download success. Sleep 20000ms...");
            Thread.sleep(20000L);
            while (this.api.poll().isFlashDownload()) {
                this.log.info((Object)"Wait for normal state");
                Thread.sleep(1000L);
            }
            this.log.info((Object)"Fast load done");
        }
        catch (InterruptedException ex) {
            try {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(raf);
                this.api.getPort().setParams(this.defParams);
                this.log.info((Object)("Finish: " + this.api.finishDownloadFirmware()));
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)raf);
        this.api.getPort().setParams(this.defParams);
        this.log.info((Object)("Finish: " + this.api.finishDownloadFirmware()));
    }

    private File getNewestFile(String prefix, String version) throws InitException {
        File res = null;
        if (Hardware.getFirmwarePath() != null && Hardware.getFirmwarePath().isDirectory()) {
            for (File f : Hardware.getFirmwarePath().listFiles()) {
                String n = f.getName();
                if (!n.matches(prefix + "-\\d{3}") || n.substring(n.length() - 3).compareTo(version) <= 0 || res != null && f.getName().compareTo(res.getName()) <= 0) continue;
                res = f;
            }
            if (res != null) {
                this.checkFile(res);
            }
        }
        return res;
    }

    private synchronized String getFirmwareBase() throws InitException, IOException {
        if (this.version == null) {
            this.version = new EbdsVersion(this.api.getAccessorType());
        }
        if (this.version.getProduct() == EbdsVersion.Product.SC) {
            return "mei-sc83";
        }
        if (this.version.getProduct() == EbdsVersion.Product.SC_ADVANCE) {
            return "mei-scn83";
        }
        throw new InitException("Unknown device type: " + this.version.getVersion());
    }

    private String getVersion(String firmware) throws InitException {
        if (firmware.matches("\\d{9}")) {
            return firmware.substring(6);
        }
        throw new InitException("Wrong version format: " + firmware);
    }

    private void checkFile(File file) throws InitException {
        if (!file.isFile() || file.length() % 32L != 0L) {
            throw new InitException("File " + file.getName() + " has wrong size=" + file.length() + ", Data size is not a multiple of 32");
        }
    }

    private void setSolidParams() {
        this.api.getConnector().setAttempts(3);
        this.api.getConnector().setAttemptsPause(2000);
    }

    private void setFastParams() {
        this.api.getConnector().setAttempts(2);
        this.api.getConnector().setAttemptsPause(100);
    }
}

