/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds.driver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.ebds.Api;
import ru.softlogic.hardware.bvr.ebds.EbdsStatus;
import ru.softlogic.hardware.bvr.ebds.EbdsVersion;
import ru.softlogic.hardware.bvr.ebds.Note;
import ru.softlogic.hardware.bvr.ebds.driver.UpdateTask;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.InitException;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.base.SimpleUpdateListener;
import ru.softlogic.hdw.base.UpdateApi;
import ru.softlogic.hdw.base.UpdateListener;
import ru.softlogic.hdw.base.UpdateOperation;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.BvrState;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends BaseCashAcceptorDriver {
    private static final String DRIVER_VERSION = "2.2.8";
    private final Api api;
    private final Logger log;
    private final HashMap<Note, Denomination> units = new HashMap();
    private final UpdateApi updateApi = new EbdsUpdateApi();
    private UpdateOperation updateFirmwareOperation;

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, currency, log);
        this.api = new Api(port, log);
        this.log = log;
    }

    protected void _run() throws InterruptedException {
        EbdsStatus lastStatus = null;
        boolean canStake = false;
        while (!Thread.currentThread().isInterrupted()) {
            this.sleep(100);
            try {
                EbdsStatus status;
                if (lastStatus == null) {
                    this.log.info((Object)"Try to open port");
                    this.api.open();
                    if (this.api.isDownloadMode()) {
                        this.log.info((Object)"Device in downloading mode, necessary to complete the flashing process");
                        this.updateState(-8);
                        UpdateTask ut = new UpdateTask(this.api, this.log);
                        ut.update((UpdateListener)new SimpleUpdateListener((BaseDevice)this));
                        this.log.info((Object)"Run update again");
                        ut = new UpdateTask(this.api, this.log);
                        ut.update((UpdateListener)new SimpleUpdateListener((BaseDevice)this));
                        this.updateState(0);
                    }
                    this.init();
                }
                if (!(status = this.api.poll()).equals(lastStatus)) {
                    this.api.debugData(status.getData());
                }
                if (status.isFailure() && (lastStatus == null || !lastStatus.isFailure())) {
                    this.notifyProblem("Failure state");
                    this.log.info((Object)"Failure, try to reset");
                    this.api.reset();
                    this.sleep(5000);
                    if (this.api.poll().isFailure()) {
                        this.log.info((Object)"Failure again, set error state");
                        this.updateState(-7);
                    }
                    lastStatus = status;
                    continue;
                }
                if (this.updateFirmwareOperation != null) {
                    this.log.info((Object)"Necessary to update the firmware");
                    this.updateState(-8);
                    UpdateTask updateTask = new UpdateTask(this.api, this.log);
                    updateTask.update(this.updateFirmwareOperation.getListener());
                    this.updateFirmwareOperation = null;
                    this.updateState(0);
                    this.init();
                }
                if (status.isOnlyIdling()) {
                    if (this.isEnabled()) {
                        if (!this.api.isEnable()) {
                            this.log.info((Object)"Enable equipment");
                            this.api.enable();
                        }
                    } else if (this.api.isEnable()) {
                        this.log.info((Object)"Disable equipment");
                        this.api.disable();
                    }
                }
                if (status.isPowerUp() && (lastStatus == null || !lastStatus.isPowerUp())) {
                    this.log.info((Object)"Power Up");
                }
                if (!(!status.isOnlyIdling() || lastStatus != null && lastStatus.isOnlyIdling() || status.isPowerUp())) {
                    this.log.info((Object)"Idling");
                    this.updateState(0);
                }
                if (status.isAccepting() && (lastStatus == null || !lastStatus.isAccepting())) {
                    this.log.info((Object)"Accepting");
                    this.api.unsetCashPolicy();
                    this.notifyEvent(1);
                }
                if (status.isEscrowed() && (lastStatus == null || !lastStatus.isEscrowed())) {
                    this.notifySafeState(false);
                    this.log.info((Object)"Escrow position");
                    Denomination d = this.convert(status);
                    if (this.canStack(d)) {
                        this.log.info((Object)"Stack bill...");
                        canStake = true;
                        this.api.stackCash();
                    } else {
                        this.api.returnCash();
                        this.notifySafeState(true);
                    }
                }
                if (status.isStacking() && (lastStatus == null || !lastStatus.isStacking())) {
                    this.log.info((Object)"Stacking");
                }
                if (status.isStacked() && (lastStatus == null || !lastStatus.isStacked())) {
                    this.log.info((Object)"Stacked");
                    this.updateState((DeviceState)new BvrState(0));
                    if (canStake) {
                        this.stack(this.convert(status));
                        this.notifyEvent(7);
                        canStake = false;
                    } else {
                        this.log.error((Object)"Flag CanStack is not set, Can't add bill");
                    }
                    this.notifySafeState(true);
                    this.api.unsetCashPolicy();
                }
                if (!(!status.isIdling() || lastStatus != null && lastStatus.isIdling() || status.isStacking() || status.isStacked())) {
                    this.log.info((Object)"Idling");
                    this.updateState(0);
                }
                if (status.isReturning() && (lastStatus == null || !lastStatus.isReturning())) {
                    this.log.info((Object)"Returning");
                }
                if (status.isReturned() && (lastStatus == null || !lastStatus.isReturned())) {
                    this.log.info((Object)"Returned");
                    this.api.unsetCashPolicy();
                }
                if (status.isCheated() && (lastStatus == null || !lastStatus.isCheated())) {
                    this.log.info((Object)"Cheated");
                }
                if (status.isRejected() && (lastStatus == null || !lastStatus.isRejected())) {
                    this.log.info((Object)"Rejected");
                    this.notifyEvent(2);
                }
                if (status.isJammed() && (lastStatus == null || !lastStatus.isJammed())) {
                    this.log.info((Object)"Jammed");
                    this.updateState(3);
                }
                if (status.isStackerFull() && (lastStatus == null || !lastStatus.isStackerFull())) {
                    this.log.info((Object)"StackerFull");
                    this.updateState(1);
                }
                if (!status.isCassetteAttached() && (lastStatus == null || lastStatus.isCassetteAttached())) {
                    this.log.info((Object)"Stack out");
                    this.updateState(2);
                }
                if (status.isPaused() && (lastStatus == null || !lastStatus.isPaused())) {
                    this.log.info((Object)"Paused");
                }
                if (status.isCalibration() && (lastStatus == null || !lastStatus.isCalibration())) {
                    this.log.info((Object)"Calibration");
                }
                if (status.isPowerUp() && (lastStatus == null || !lastStatus.isPowerUp())) {
                    this.log.info((Object)"Power Up");
                }
                if (status.isInvalidCommand() && (lastStatus == null || !lastStatus.isInvalidCommand())) {
                    this.log.info((Object)"Invalid Command");
                }
                lastStatus = status;
                this.onConnSuccess();
            }
            catch (IOException ex) {
                this.onConnError(ex);
                this.randomSleep(500, 500);
                lastStatus = null;
                this.api.close();
            }
        }
    }

    private Denomination convert(EbdsStatus st) {
        Note n = this.api.createNote(st.getExtendedData());
        int nominal = (int)((double)n.getBase() * Math.pow(10.0, n.getExponent()));
        Denomination d = this.getBill(n.getIsoCode(), nominal * 100);
        this.log.info((Object)("    " + n + "->" + d));
        return d;
    }

    private void init() throws IOException {
        Note n;
        this.log.info((Object)"------------------------------------------------------------------------");
        this.log.info((Object)"Reset");
        this.api.reset();
        this.log.info((Object)"Success");
        this.log.info((Object)("Reset count: " + this.api.queryDeviceResets()));
        this.api.returnCash();
        this.api.unsetCashPolicy();
        this.log.info((Object)"--------------------------");
        this.log.info((Object)"Bill validator info:");
        String type = this.api.getAccessorType();
        this.log.info((Object)("Model: " + type));
        String serial = this.api.getAccessorSerialNumber();
        String boot = this.api.getAccessorBootPartNumner();
        String variantName = this.api.getAccessorVariant();
        String variantPart = this.api.getAccessorVariantPart();
        String variantId = this.api.getAccessorVariantId();
        String appPart = this.api.getAccessorApplicationPartNumber();
        String appId = this.api.getAccessorApplicationId();
        this.updateState(0);
        this.log.info((Object)("Serial: " + serial));
        this.log.info((Object)("Boot path: " + boot));
        this.log.info((Object)("Application part #/ID: " + appPart + "/" + appId));
        this.log.info((Object)("Variant part #/ID: " + variantPart + "/" + variantId));
        this.log.info((Object)("Variant name: " + variantName));
        this.log.info((Object)"Note description: ");
        HashSet<Denomination> denominations = new HashSet<Denomination>();
        this.units.clear();
        for (int i = 1; i <= 50 && (n = this.api.getNoteDescription(i)) != null; ++i) {
            int nominal = (int)((double)n.getBase() * Math.pow(10.0, n.getExponent()));
            Denomination den = this.getBill(n.getIsoCode(), nominal * 100);
            this.log.info((Object)("    " + n + "->" + den));
            this.units.put(n, den);
            if (den == null) continue;
            denominations.add(den);
        }
        EbdsVersion version = new EbdsVersion(this.api.getAccessorType());
        this.log.info((Object)("Version: " + version));
        DeviceInfo info = this.createDeviceInfo("MEI", "EBDS", DRIVER_VERSION, denominations, version.getCassetteSize() > 0 ? Integer.valueOf(version.getCassetteSize()) : null);
        info.setSerial(serial);
        info.setInfo(variantName);
        info.setFirmware(this.getVersion(appId));
        info.setFirmware1(this.getVersion(variantId));
        info.setFirmware2(appId + "/" + variantId);
        info.setModel(type);
        this.log.info((Object)"---");
        try {
            File bs;
            LinkedList<String> files = new LinkedList<String>();
            UpdateTask updateTask = new UpdateTask(this.api, this.log);
            File app = updateTask.getNewestAppFile();
            if (app != null) {
                files.add(app.getName());
            }
            if ((bs = updateTask.getNewestBillSetFile()) != null) {
                files.add(bs.getName());
            }
            info.setUpdateList(files);
            info.setHasUpdate(!files.isEmpty());
        }
        catch (InitException ex) {
            this.log.error((Object)"Error on search newest firmwares", (Throwable)ex);
        }
        this.updateDeviceInfo(info);
    }

    public UpdateApi getUpdateApi() {
        return this.updateApi;
    }

    private String getVersion(String firmware) {
        if (firmware.matches("\\d{9}")) {
            return firmware.substring(6, 7) + "." + firmware.substring(7);
        }
        return firmware;
    }

    protected long getNormalAccTimeout() {
        return 1500L;
    }

    private class EbdsUpdateApi
    implements UpdateApi {
        private EbdsUpdateApi() {
        }

        public void update(UpdateOperation operation) {
            Driver.this.updateFirmwareOperation = operation;
        }
    }
}

