/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ebds;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.ebds.Reply;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connector {
    public static final int CMD_OMNIBUS = 16;
    public static final int CMD_DOWNLOAD = 80;
    public static final int CMD_AUXILIARY = 96;
    public static final int CMD_EXTENDED = 112;
    private static final byte STX = 2;
    private static final byte ETX = 3;
    private static final int MAX_LEN = 20;
    private final SerialPort port;
    private final Logger log;
    private int attempts = 5;
    private int attemptsPause = 2000;
    private int attemptsTimeout = 1000;
    private int flag = 0;

    public Connector(SerialPort port, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.port = port;
        this.log = log;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public int getAttemptsPause() {
        return this.attemptsPause;
    }

    public void setAttemptsTimeout(int timeout) {
        this.attemptsTimeout = timeout;
    }

    public void setAttemptsPause(int attemptsTimeout) {
        this.attemptsPause = attemptsTimeout;
    }

    public void reverseFlag() {
        this.flag ^= 1;
    }

    public byte[] sendCommand(int ctl, byte[] data, Integer timeout) throws IOException {
        int to = timeout == null ? this.attemptsTimeout : timeout;
        Reply responce = this._sendCommand(ctl + this.flag, data, true, true, to);
        this.flag ^= 1;
        return responce.getData();
    }

    public Reply sendCommand(int ctl, byte[] data, boolean checkEcho, Integer timeout) throws IOException {
        int to = timeout == null ? this.attemptsTimeout : timeout;
        Reply responce = this._sendCommand(ctl + this.flag, data, false, checkEcho, to);
        this.flag ^= 1;
        return responce;
    }

    private Reply _sendCommand(int ctl, byte[] data, boolean retryOnNak, boolean checkEcho, int timeout) throws IOException {
        IOException lastEx = null;
        for (int i = 0; i < this.attempts; ++i) {
            try {
                Reply r = this.sendData(ctl, data, checkEcho, timeout);
                if (r.isNak() && retryOnNak) {
                    throw new IOException("Nak " + r);
                }
                return r;
            }
            catch (IOException ex) {
                lastEx = ex;
                this.log.error((Object)"Error on write data ", (Throwable)ex);
                if (i + 1 >= this.attempts || this.attemptsPause <= 0) continue;
                try {
                    Random rnd = new Random();
                    int r = rnd.nextInt(this.attemptsPause);
                    this.log.info((Object)("Sleep " + r + " msec"));
                    Thread.sleep(r);
                    continue;
                }
                catch (InterruptedException ex1) {
                    Thread.currentThread().interrupt();
                    throw new IOException(ex1);
                }
            }
        }
        throw new IOException("Can't send packet", lastEx);
    }

    public void onlySendCommand(int ctl, byte[] data, int timeout) throws IOException {
        byte[] request = this.formMessage(ctl + this.flag, data);
        this.port.setTimeout(200);
        this.log.info((Object)(">>" + BU.toString((byte[])request)));
        this.port.write(request);
        this.port.setTimeout(timeout);
        byte[] res = this.port.tryRead();
        this.log.info((Object)("<<" + BU.toString((byte[])res)));
        this.flag ^= 1;
    }

    private Reply sendData(int ctl, byte[] data, boolean checkEcho, int timeout) throws IOException {
        byte[] request = this.formMessage(ctl, data);
        this.port.setTimeout(200);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(">>" + BU.toString((byte[])request)));
        }
        this.port.flush(Flush.RxTx);
        this.port.write(request);
        this.port.setTimeout(timeout);
        this.port.read(1, (byte)2, 20);
        int len = this.port.readByte();
        if (len < 5 || len > 254) {
            throw new IOException("Wrong answer len: " + len);
        }
        byte[] rdata = this.port.read(len - 2);
        byte[] response = new byte[len];
        response[0] = 2;
        response[1] = BU.c((int)len);
        System.arraycopy(rdata, 0, response, 2, rdata.length);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("<<" + BU.toString((byte[])response)));
        }
        if (response[response.length - 2] != 3) {
            throw new IOException("ETX is not found");
        }
        if (response[response.length - 1] != this.getCrc(response)) {
            throw new IOException("Response CRC is wrong");
        }
        if ((response[2] & 0xE) != 0) {
            throw new IOException("Wrong DeviceType");
        }
        if (checkEcho && Arrays.equals(request, response)) {
            throw new IOException("Echo detect");
        }
        byte[] res = new byte[rdata.length - 2];
        System.arraycopy(rdata, 0, res, 0, res.length);
        res[0] = BU.c((int)(res[0] & 0xF0));
        return new Reply(res, (response[2] & 1) != (request[2] & 1));
    }

    private byte[] formMessage(int ctl, byte[] data) {
        byte[] res = new byte[data == null ? 0 : data.length + 5];
        res[0] = 2;
        res[1] = BU.c((int)res.length);
        res[2] = BU.c((int)ctl);
        if (data != null) {
            System.arraycopy(data, 0, res, 3, data.length);
        }
        res[res.length - 2] = 3;
        res[res.length - 1] = this.getCrc(res);
        return res;
    }

    private byte getCrc(byte[] res) {
        byte crc = 0;
        for (int i = 1; i < res.length - 2; ++i) {
            crc = (byte)(crc ^ res[i] & 0xFF);
        }
        return crc;
    }
}

