/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ccnet.driver;

import java.util.LinkedList;
import java.util.List;

class UpdateBlock {
    private int len;
    private int hAdr;
    private int lAdr;
    private final LinkedList<Byte> data = new LinkedList();

    public byte[] buildRequest() {
        byte[] req = new byte[this.data.size() + 6];
        req[0] = 2;
        req[1] = this.getFirstByteLen();
        req[2] = this.getSecondByteLen();
        req[3] = this.getThirdByteAdr();
        req[4] = this.getSecondByteAdr();
        req[5] = this.getFirstByteAdr();
        for (int i = 0; i < this.data.size(); ++i) {
            req[i + 6] = this.data.get(i);
        }
        return req;
    }

    public byte getFirstByteLen() {
        return (byte)(this.len + 12 >> 8 & 0xFF);
    }

    public byte getSecondByteLen() {
        return (byte)(this.len + 12 & 0xFF);
    }

    public byte getFirstByteAdr() {
        return (byte)(this.hAdr & 0xFF);
    }

    public byte getSecondByteAdr() {
        return (byte)(this.lAdr >> 8 & 0xFF);
    }

    public byte getThirdByteAdr() {
        return (byte)(this.lAdr & 0xFF);
    }

    public void addData(String code) {
        for (int i = 0; i < code.length(); i += 2) {
            Byte b = (byte)Integer.parseInt(code.substring(i, i + 2), 16);
            this.data.add(b);
        }
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void sethAdr(int hAdr) {
        this.hAdr = hAdr;
    }

    public void setlAdr(int lAdr) {
        this.lAdr = lAdr;
    }

    public List<Byte> getData() {
        return this.data;
    }
}

