/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ccnet.driver;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bvr.ccnet.Api;
import ru.softlogic.hardware.bvr.ccnet.BillType;
import ru.softlogic.hardware.bvr.ccnet.CcnetInfo;
import ru.softlogic.hardware.bvr.ccnet.CcnetStatus;
import ru.softlogic.hardware.bvr.ccnet.driver.Updater;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.UpdateFailureException;
import ru.softlogic.hdw.base.UpdateApi;
import ru.softlogic.hdw.base.UpdateListener;
import ru.softlogic.hdw.base.UpdateOperation;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.BvrState;
import ru.softlogic.hdw.dev.cashacc.impl.BaseCashAcceptorDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Driver
extends BaseCashAcceptorDriver
implements UpdateApi {
    private static final String DRIVER_VERSION = "2.1.0";
    private final Api api;
    private final Logger log;
    private int resetCount = 0;
    private final Map<Integer, Denomination> units = new HashMap<Integer, Denomination>();
    private UpdateOperation operation;
    private CcnetInfo ccnetInfo;
    private final Updater updater;

    public Driver(String type, SerialPort port, BvrOptions options, String currency, Logger log) {
        super(new DeviceId(3, type, 0), port, currency, log);
        this.api = new Api(port, log);
        this.updater = new Updater(this.api, log);
        this.log = log;
    }

    public void _run() throws InterruptedException {
        boolean canStack = false;
        CcnetStatus lastStatus = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (lastStatus == null) {
                    this.log.debug((Object)"Last status is null");
                    this.api.open();
                    if (this.api.isDownloadMode()) {
                        this.emergencyUpdate();
                    } else {
                        this.log.info((Object)"Send reset");
                        this.api.reset();
                    }
                    this.sleep(500);
                }
                this.sleep(100);
                CcnetStatus currStatus = this.api.poll();
                if (lastStatus != null && lastStatus.getStatus() == 19 && !lastStatus.equals(currStatus) || currStatus.getStatus() == 25 && lastStatus == null) {
                    this.log.info((Object)("Current status = " + currStatus));
                    if (currStatus.getStatus() == 67 || currStatus.getStatus() == 68 || currStatus.getStatus() == 24) {
                        this.log.info((Object)"Wrong status, skip reinit");
                    } else {
                        this.init();
                    }
                }
                switch (currStatus.getStatus()) {
                    case 25: {
                        this.notifySafeState(true);
                        this.resetCount = 0;
                        if (this.operation != null) {
                            UpdateListener ul = this.operation.getListener();
                            this.operation = null;
                            this.normalUpdate(ul);
                        }
                        if (!this.isEnabled()) break;
                        this.api.enable();
                        break;
                    }
                    case 20: {
                        this.notifySafeState(true);
                        this.resetCount = 0;
                        if (this.isEnabled()) break;
                        this.api.disable();
                    }
                }
                if (currStatus.equals(lastStatus)) continue;
                block5 : switch (currStatus.getStatus()) {
                    case 16: 
                    case 17: 
                    case 18: {
                        this.log.info((Object)"Power up");
                        this.api.reset();
                        break;
                    }
                    case 21: {
                        this.log.info((Object)"Accepting");
                        this.notifyEvent(1);
                        break;
                    }
                    case 23: {
                        this.log.info((Object)"Stacking");
                        break;
                    }
                    case 24: {
                        this.log.info((Object)"Returning");
                        canStack = false;
                        this.notifySafeState(true);
                        break;
                    }
                    case 26: {
                        this.log.debug((Object)"Hold");
                        break;
                    }
                    case 27: {
                        this.log.info((Object)("Buzy, sleep 100*" + currStatus.getSubStatus() + " ms"));
                        this.sleep(100 * currStatus.getSubStatus());
                        break;
                    }
                    case 65: {
                        this.log.info((Object)"Stack overflow");
                        this.updateState((DeviceState)new BvrState(1));
                        break;
                    }
                    case 66: {
                        this.log.info((Object)"Stack out");
                        this.updateState((DeviceState)new BvrState(2));
                        break;
                    }
                    case 67: {
                        this.log.info((Object)"Bill jamm in head");
                        this.updateState((DeviceState)new BvrState(3));
                        this.tryRestore();
                        break;
                    }
                    case 68: {
                        this.log.info((Object)"Bill jamm in stack");
                        this.updateState((DeviceState)new BvrState(4));
                        this.tryRestore();
                        break;
                    }
                    case 69: {
                        this.log.info((Object)"Cheat?");
                        this.notifyFraud(0);
                        break;
                    }
                    case 70: {
                        this.log.info((Object)"Pause");
                        break;
                    }
                    case 25: {
                        this.log.info((Object)"Unit disable");
                        this.updateState((DeviceState)new BvrState(0));
                        break;
                    }
                    case 20: {
                        this.log.info((Object)"Idle");
                        this.updateState((DeviceState)new BvrState(0));
                        break;
                    }
                    case 19: {
                        this.log.info((Object)"Init");
                        break;
                    }
                    case 128: {
                        Denomination d = this.units.get(currStatus.getSubStatus());
                        this.log.info((Object)("Escrow position, note id: " + currStatus.getSubStatus() + "->" + d));
                        this.notifySafeState(false);
                        if (this.canStack(d)) {
                            canStack = true;
                            this.api.stackCash();
                            break;
                        }
                        this.api.returnCash();
                        this.notifySafeState(true);
                        break;
                    }
                    case 129: {
                        if (lastStatus != null && lastStatus.getStatus() == 24) {
                            this.notifyFraud(5);
                        }
                        Denomination d = this.units.get(currStatus.getSubStatus());
                        this.log.info((Object)("Stacked note id=" + currStatus.getSubStatus() + "->" + d));
                        if (d.getType() == 1 || canStack) {
                            this.stack(d);
                            this.notifyEvent(7);
                        } else {
                            this.notifyProblem("Flag CanStack is not set, Can't add bill");
                        }
                        this.notifySafeState(true);
                        canStack = false;
                        break;
                    }
                    case 130: {
                        this.log.info((Object)"Bill returned");
                        break;
                    }
                    case 28: {
                        if (lastStatus != null && lastStatus.getStatus() == 23) {
                            this.notifyFraud(1);
                        }
                        switch (currStatus.getSubStatus()) {
                            case 96: {
                                this.log.info((Object)"Reject: insert error");
                                this.notifyEvent(2);
                                this.notifyFraud(3);
                                break;
                            }
                            case 97: {
                                this.log.info((Object)"Reject: dielectric error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 98: {
                                this.log.info((Object)"Reject: previos bill in head");
                                this.notifyEvent(2);
                                break;
                            }
                            case 99: {
                                this.log.info((Object)"Reject: multiple factor error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 100: {
                                this.log.info((Object)"Reject: transport error");
                                this.notifyEvent(6);
                                this.notifyFraud(3);
                                break;
                            }
                            case 101: {
                                this.log.info((Object)"Reject: identification error");
                                this.notifyEvent(5);
                                this.notifyFraud(2);
                                break;
                            }
                            case 102: {
                                this.log.info((Object)"Reject: verification error");
                                this.notifyEvent(5);
                                this.notifyFraud(2);
                                break;
                            }
                            case 103: {
                                this.log.info((Object)"Reject: optic error");
                                this.notifyEvent(3);
                                this.notifyFraud(2);
                                break;
                            }
                            case 104: {
                                this.log.debug((Object)"Reject: inhibit error");
                                break;
                            }
                            case 106: {
                                this.log.info((Object)"Reject: operation error");
                                this.notifyEvent(2);
                                break;
                            }
                            case 108: {
                                this.log.debug((Object)"Reject: length error");
                                this.notifyEvent(4);
                                break;
                            }
                            case 109: {
                                this.log.info((Object)"Reject: UV");
                                this.notifyEvent(2);
                                break;
                            }
                            case 146: 
                            case 147: 
                            case 148: 
                            case 149: {
                                this.log.debug((Object)"Reject: barcode");
                                this.notifyEvent(2);
                                break;
                            }
                            default: {
                                this.notifyProblemOnce("Unknown reject cause: " + BU.toHex((int)currStatus.getSubStatus()));
                            }
                        }
                        this.notifySafeState(true);
                        this.log.debug((Object)"Reject");
                        break;
                    }
                    case 71: {
                        switch (currStatus.getSubStatus()) {
                            case 80: {
                                this.log.info((Object)"Fail: stack motor");
                                this.updateState((DeviceState)new BvrState(5));
                                break block5;
                            }
                            case 81: 
                            case 82: {
                                this.log.info((Object)"Fail: transport motor");
                                this.updateState((DeviceState)new BvrState(6));
                                break block5;
                            }
                            case 83: {
                                this.log.info((Object)"Fail: align motor");
                                this.updateState((DeviceState)new BvrState(7));
                                break block5;
                            }
                            case 84: {
                                this.log.info((Object)"Fail: init stack");
                                this.updateState((DeviceState)new BvrState(8));
                                break block5;
                            }
                            case 85: {
                                this.log.info((Object)"Fail: optic canal");
                                this.updateState((DeviceState)new BvrState(9));
                                break block5;
                            }
                            case 86: {
                                this.log.info((Object)"Fail: magnetic canal");
                                this.updateState((DeviceState)new BvrState(10));
                                break block5;
                            }
                            case 95: {
                                this.log.info((Object)"Fail: capacitance canal");
                                this.updateState((DeviceState)new BvrState(11));
                                break block5;
                            }
                            case 155: {
                                this.log.info((Object)"Fail: lost communication with the SmartStick");
                                this.updateState((DeviceState)new BvrState(-7));
                            }
                        }
                        this.notifyProblemOnce("Unknown fail cause: " + BU.toHex((int)currStatus.getSubStatus()));
                        this.updateState((DeviceState)new BvrState(-7));
                        break;
                    }
                    default: {
                        this.notifyProblemOnce("Unknown poll state: " + BU.toHex((int)currStatus.getSubStatus()));
                    }
                }
                lastStatus = currStatus;
                this.onConnSuccess();
            }
            catch (IOException ex) {
                this.onConnError(ex);
                this.api.close();
                this.randomSleep(500, 500);
                lastStatus = null;
            }
        }
    }

    private void tryRestore() throws IOException {
        ++this.resetCount;
        if (this.resetCount < 5) {
            this.api.reset();
        }
    }

    public UpdateApi getUpdateApi() {
        return this.updater.isSupportFwUpdate(this.ccnetInfo) ? this : null;
    }

    public void update(UpdateOperation operation) {
        if (operation == null) {
            throw new NullPointerException("UpdateOperation is null");
        }
        this.operation = operation;
    }

    private void init() throws IOException {
        this.log.debug((Object)"Init done. Get status");
        this.log.debug((Object)"Set options");
        HashSet<Denomination> den = new HashSet<Denomination>();
        BillType[] billTypes = this.api.billTable();
        if (billTypes != null) {
            this.log.info((Object)"Bill table: ");
            boolean bill = true;
            int nom = 0;
            this.units.clear();
            for (BillType bt : billTypes) {
                if (bt.getNominal() < nom && bill) {
                    bill = false;
                }
                Denomination d = bill ? this.getBill(bt.getCurrency(), bt.getNominal() * 100) : this.getCoin(bt.getCurrency(), bt.getNominal() * 100);
                nom = bt.getNominal();
                this.log.info((Object)("    " + bt + "->" + d));
                this.units.put(bt.getId(), d);
                if (d == null) continue;
                den.add(d);
            }
        } else {
            this.log.error((Object)"Bill table is wrong");
        }
        DeviceInfo info = this.createDeviceInfo("CashCode", "CCNET", DRIVER_VERSION, den);
        this.ccnetInfo = this.api.identification();
        this.log.info((Object)"Device info:");
        this.log.info((Object)("    Model: " + this.ccnetInfo.getModel()));
        this.log.info((Object)("    Firmware: " + this.ccnetInfo.getFirmware()));
        this.log.info((Object)("    Part number: " + this.ccnetInfo.getPartNumber()));
        this.log.info((Object)("    Serial number: " + this.ccnetInfo.getSerialNumber()));
        info.setModel(this.ccnetInfo.getModel());
        info.setFirmware(this.ccnetInfo.getFirmware());
        info.setSerial(this.ccnetInfo.getSerialNumber());
        this.updater.checkFirmwareUpdate(info);
        this.updateDeviceInfo(info);
    }

    private void emergencyUpdate() throws IOException, InterruptedException {
        this.log.info((Object)"Device in downloading mode, necessary to complete the flashing process");
        try {
            this.updateState(-8);
            this.updater.onlyLoad();
            this.updateState(0);
        }
        catch (UpdateFailureException ex) {
            this.log.error((Object)"Error on load firmware", (Throwable)ex);
            this.updateState(-7);
            Thread.currentThread().interrupt();
        }
    }

    private void normalUpdate(UpdateListener listener) throws IOException, InterruptedException {
        try {
            long start = System.currentTimeMillis();
            this.updateState(-8);
            this.updater.update();
            this.updateState(0);
            listener.onSuccess(System.currentTimeMillis() - start);
        }
        catch (UpdateFailureException ex) {
            this.log.error((Object)"Error on load firmware", (Throwable)ex);
            listener.onError(ex.getMessage());
        }
    }
}

