/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bvr.ccnet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.WrongCommandException;
import ru.softlogic.io.StartStorage;
import ru.softlogic.io.Storage;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Connector {
    public static final byte SYNC = 2;
    public static final byte CMD_POLL = 51;
    public static final byte CMD_RESET = 48;
    public static final byte CMD_STATUS = 49;
    public static final byte CMD_SECURE = 50;
    public static final byte CMD_ENABLE = 52;
    public static final byte CMD_DISABLE = 52;
    public static final byte CMD_STACK = 53;
    public static final byte CMD_RETURN = 54;
    public static final byte CMD_IDENTIFICATION = 55;
    public static final byte CMD_BILLTABLE = 65;
    public static final byte CMD_UPDATE_MODE = 80;
    private static final int DEFAULT_TIMEOUT = 1500;
    private final SerialPort port;
    private final Logger log;
    private int attempts = 3;
    private int attemptsTimeout = 300;

    public Connector(SerialPort port, Logger log) {
        if (port == null) {
            throw new IllegalArgumentException("SerialPort is null");
        }
        if (log == null) {
            throw new IllegalArgumentException("Logger is null");
        }
        this.port = port;
        this.log = log;
    }

    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
        this.port.setRTS(false);
        this.port.setDTR(false);
    }

    public void close() {
        this.port.close();
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getAttemptsTimeout() {
        return this.attemptsTimeout;
    }

    public void setAttemptsTimeout(int attemptsTimeout) {
        this.attemptsTimeout = attemptsTimeout;
    }

    public final byte[] sendCommand(byte cmd) throws IOException {
        return this.sendCommand(cmd, null, true, null);
    }

    public final byte[] sendCommand(byte cmd, int timeout) throws IOException {
        return this.sendCommand(cmd, null, true, timeout);
    }

    public final byte[] sendCommand(byte cmd, byte[] data) throws IOException {
        return this.sendCommand(cmd, data, true, null);
    }

    public final byte[] sendCommand(byte cmd, byte[] data, boolean sendAns) throws IOException {
        return this.sendCommand(cmd, data, sendAns, null);
    }

    public final byte[] sendCommand(byte cmd, byte[] data, boolean sendAns, Integer timeout) throws IOException {
        try {
            return this.sendCommandEx(cmd, data, sendAns, timeout);
        }
        catch (WrongCommandException ex) {
            throw new IOException(ex);
        }
    }

    public final byte[] sendCommandEx(byte cmd, byte[] data, boolean sendAns, Integer timeout) throws IOException, WrongCommandException {
        IOException lastEx = null;
        byte[] request = Connector.formMessage(cmd, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(">>" + BU.toString((byte[])request)));
                }
                this.port.setTimeout(timeout != null ? timeout : 1500);
                this.port.write(request);
                byte[] header = this.port.read((Storage)new StartStorage(2, 3));
                int len = BU.c((byte)header[2]);
                if (len < 4) {
                    throw new IOException("Wrong answer lenght: " + BU.toString((byte[])header));
                }
                this.port.setTimeout(2000 + len * 125);
                byte[] rdata = this.port.read(len - 3);
                byte[] response = new byte[len];
                System.arraycopy(header, 0, response, 0, header.length);
                System.arraycopy(rdata, 0, response, 3, len - 3);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("<<" + BU.toString((byte[])response)));
                }
                this.checkAnswer(request, response, sendAns);
                byte[] result = new byte[response.length - 5];
                System.arraycopy(response, 3, result, 0, result.length);
                return result;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
            catch (IOException e) {
                lastEx = e;
                this.log.error((Object)e, (Throwable)e);
                this.reopen(i);
                continue;
            }
        }
        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0441\u043b\u0430\u0442\u044c \u043f\u0430\u043a\u0435\u0442!", lastEx);
    }

    private static byte[] formMessage(byte cmd, byte[] data) {
        int dataLen = 6;
        boolean flag = false;
        if (data != null) {
            flag = data.length >= 64;
            dataLen += data.length;
        }
        byte[] request = new byte[dataLen];
        request[0] = 2;
        request[1] = 3;
        request[2] = flag ? (byte)0 : BU.c((int)dataLen);
        request[3] = cmd;
        if (data != null) {
            System.arraycopy(data, 0, request, 4, data.length);
        }
        Connector.signCrc16(request);
        return request;
    }

    private static void signCrc16(byte[] data) {
        if (data.length < 2) {
            return;
        }
        int crc = Connector.makeCrc16(data);
        data[data.length - 2] = (byte)(crc & 0xFF);
        data[data.length - 1] = (byte)(crc >> 8 & 0xFF);
    }

    private static boolean checkCrc16(byte[] data) {
        if (data.length < 6) {
            return false;
        }
        int crc = Connector.makeCrc16(data);
        byte crc1 = (byte)(crc & 0xFF);
        byte crc2 = (byte)(crc >> 8 & 0xFF);
        return data[data.length - 2] == crc1 && data[data.length - 1] == crc2;
    }

    private static int makeCrc16(byte[] data) {
        int crc = 0;
        if (data.length < 2) {
            return crc;
        }
        for (int i = 0; i < data.length - 2; ++i) {
            crc ^= 0xFF & data[i];
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) > 0) {
                    crc >>= 1;
                    crc ^= 0x8408;
                    continue;
                }
                crc >>= 1;
            }
        }
        return crc;
    }

    private void checkAnswer(byte[] request, byte[] response, boolean sendAns) throws IOException, InterruptedException, WrongCommandException {
        if (request[4] != 48 && Arrays.equals(request, response)) {
            throw new IOException("Echo detected: " + BU.toString((byte[])request));
        }
        if (!Connector.checkCrc16(response)) {
            Thread.sleep(20L);
            if (sendAns) {
                this.port.write(Connector.formMessage(BU.c((int)255), null));
            }
            throw new IOException("Wrong responce CRC: " + BU.toString((byte[])response));
        }
        if (response.length == 6 && BU.c((byte)response[3]) == 255) {
            throw new IOException("Nak received");
        }
        if (response.length == 6 && BU.c((byte)response[3]) == 48) {
            throw new WrongCommandException();
        }
        if (sendAns) {
            this.port.write(Connector.formMessage((byte)0, null));
        }
    }

    private void reopen(int i) throws IOException {
        if (i + 1 < this.attempts) {
            try {
                Random rnd = new Random();
                int r = rnd.nextInt(this.attemptsTimeout);
                this.log.info((Object)("Sleep " + r + " msec"));
                Thread.sleep(r);
                this.port.reopen();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

