/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bar.pcsc.driver;

import java.security.Provider;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bar.BaseDriver;
import ru.softlogic.hdw.dev.barcode.BarOptions;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class Driver
extends BaseDriver {
    private static final String DRIVER_VERSION = "1.0.0";
    private static final CommandAPDU GET_UID = new CommandAPDU(BU.convertFromHex((String)"FF CA 00 00 00"));
    private final Logger log;

    public Driver(String type, SerialPort port, BarOptions options, Logger log) {
        super(type, port, options, log);
        this.log = log;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        TerminalFactory factory = TerminalFactory.getDefault();
        this.log.info((Object)("Default type: " + TerminalFactory.getDefaultType()));
        Provider pr = factory.getProvider();
        this.log.info((Object)"Provider");
        this.log.info((Object)("    Name: " + pr.getName()));
        this.log.info((Object)("    Info: " + pr.getInfo()));
        this.log.info((Object)("    Services: " + pr.getServices()));
        this.log.info((Object)("    Version: " + pr.getVersion()));
        try {
            this.log.info((Object)"Available terminals:");
            CardTerminal selected = null;
            for (CardTerminal ct : factory.terminals().list()) {
                this.log.info((Object)("    " + ct.getName()));
                if (!ct.getName().contains("-CL")) continue;
                selected = ct;
            }
            this.log.info((Object)("Selected terminal: " + selected));
            DeviceInfo di = new DeviceInfo(10, "pcsc");
            di.setDriver(DRIVER_VERSION);
            di.setModel(selected != null ? selected.getName() : null);
            DeviceState ds = new DeviceState(10, selected != null ? 0 : -1);
            this.updateDeviceInfo(di);
            this.updateState(ds);
            if (selected == null) {
                throw new CardException("Wireless terminal is not found");
            }
            this.loop(selected);
        }
        catch (CardException ex) {
            this.log.error((Object)"Error on list");
        }
        this.log.info((Object)"Stop thread");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loop(CardTerminal terminal) {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.log.info((Object)"Wait for card");
                    if (!terminal.waitForCardPresent(Long.MAX_VALUE)) continue;
                    Card card = terminal.connect("*");
                    this.log.info((Object)("Connected to " + terminal.getName()));
                    this.log.info((Object)("    ATR: " + BU.toString((byte[])card.getATR().getBytes()) + card.getProtocol()));
                    CardChannel channel = card.getBasicChannel();
                    this.log.info((Object)"Read UIN");
                    ResponseAPDU r = channel.transmit(GET_UID);
                    this.log.info((Object)("    " + r + "|" + BU.toString((byte[])r.getBytes())));
                    if (r.getSW() == 36864) {
                        long val = 0L;
                        for (int i = 0; i < r.getNr(); ++i) {
                            val = (val << 8) + (long)BU.c((byte)r.getBytes()[i]);
                        }
                        this.log.info((Object)("Value: " + val));
                        this.notifyBarcode(Long.toString(val));
                    }
                    channel.close();
                    this.log.info((Object)"Wait for absent");
                    terminal.waitForCardAbsent(Long.MAX_VALUE);
                }
                catch (CardException ex) {
                    this.log.error((Object)"Error on process card", (Throwable)ex);
                    Thread.sleep(1000L);
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

