/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.bar.keyboard.driver;

import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.bar.BaseDriver;
import ru.softlogic.hdw.dev.barcode.BarOptions;
import ru.softlogic.hdw.dev.barcode.Control;
import ru.softlogic.io.serial.SerialPort;

public class Driver
extends BaseDriver {
    private static final long THRESHOLD = 30L;
    private final char[] buffer;
    private int index;
    private final Control control;
    private final Logger log;
    private boolean wait;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>();

    public Driver(String type, SerialPort port, BarOptions options, Logger log) {
        super(type, port, options, log);
        this.log = log;
        this.buffer = new char[2000];
        this.control = new LocalScannerControl();
        this.wait = true;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.updateDeviceInfo(this.createDeviceInfo());
        this.updateState(0);
        try {
            StringBuilder sb = null;
            while (!Thread.currentThread().isInterrupted()) {
                String data = this.queue.take();
                this.log.info((Object)("Get piece: " + data));
                if (sb == null) {
                    sb = new StringBuilder(data);
                } else {
                    sb.append('\n').append(data);
                }
                Thread.sleep(30L);
                if (this.index != 0) continue;
                this.notifyBarcode(sb.toString());
                sb = null;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    private class LocalScannerControl
    implements Control {
        private LocalScannerControl() {
        }

        public void onSymbol(char symbol) {
            if (symbol == '\n' || symbol == '\r') {
                String data = new String(Driver.this.buffer, 0, Driver.this.index);
                Driver.this.log.debug((Object)("Data: " + data));
                Driver.this.index = 0;
                Arrays.fill(Driver.this.buffer, '\u0000');
                Driver.this.queue.add(data);
                Driver.this.wait = true;
            } else {
                if (Driver.this.wait) {
                    Driver.this.log.info((Object)"Begin barcode");
                    Driver.this.wait = false;
                }
                Driver.this.log.debug((Object)("add symbol: " + symbol));
                ((Driver)Driver.this).buffer[((Driver)Driver.this).index] = symbol;
                Driver.this.index = (Driver.this.index + 1) % 2000;
            }
        }
    }
}

