/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.ioc.cio20.driver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.ioc.cio20.api.Api;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.ioc.DoorApi;
import ru.softlogic.hdw.dev.ioc.DoorTask;
import ru.softlogic.hdw.dev.ioc.IOController;
import ru.softlogic.hdw.dev.ioc.IOControllerDriver;
import ru.softlogic.hdw.dev.ioc.IOControllerException;
import ru.softlogic.hdw.dev.ioc.IOLinesState;
import ru.softlogic.hdw.dev.ioc.LineState;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.dev.sensors.SensorDriver;
import ru.softlogic.hdw.dev.sensors.SensorEvent;
import ru.softlogic.hdw.dev.sensors.SensorsListener;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;
import ru.softlogic.io.utils.SerialFmt;

public class Driver
extends SensorDriver
implements IOControllerDriver,
IOController {
    private static final String DRIVER_VERSION = "2.1.0";
    private final Api api;
    private final SerialPort port;
    private final DoorApi doorApi;
    private boolean inited = false;
    private Integer lastOutputs;

    public Driver(SerialPort port, Logger log) {
        super(new DeviceId(21, "CIO-20", 0), (Port)port, "2.0.0", log);
        this.api = new Api(port, log);
        this.port = port;
        this.doorApi = new CIO20DoorApi();
        this.registrationSensor();
    }

    protected void _run() throws InterruptedException {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!this.inited) {
                    this.init();
                }
                this.updateSensorState();
                this.checkOuts();
                this.sleep(500);
            }
            catch (IOException | IOControllerException ex) {
                this.onConnError((Exception)ex);
                this.randomSleep(800, 500);
                this.api.close();
                this.inited = false;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public DoorApi getDoorApi() {
        return this.doorApi;
    }

    private void checkOuts() throws IOControllerException {
        int res = this.api.outputsInfo();
        if (this.lastOutputs == null || res != this.lastOutputs) {
            this.log.info((Object)("New outputs: " + BU.toHex((int)res)));
            this.lastOutputs = res;
        }
    }

    private void registrationSensor() {
        for (int i = 1; i <= 20; ++i) {
            this.registrationSensor(new Sensor(21, 1, i));
        }
    }

    private void init() throws IOException, IOControllerException {
        this.log.info((Object)"INIT");
        this.api.open();
        this.api.autodetectin(false);
        this.setOutputStatus(-1, LineState.STATUS_OFF);
        DeviceInfo di = new DeviceInfo(21, "CIO-20");
        di.setDriver(DRIVER_VERSION);
        di.setSerial(this.api.getSerialNumber());
        di.setPort(SerialFmt.format((SerialPort)this.port));
        di.setModel(this.api.getName());
        this.log.info((Object)("    Model: " + di.getModel()));
        this.log.info((Object)("    Serial number: " + di.getSerial()));
        this.log.info((Object)("    Port:" + di.getPort()));
        this.updateDeviceInfo(di);
        this.updateState(new DeviceState(21, 0));
        this.inited = true;
    }

    private void updateSensorState() throws IOException {
        try {
            IOLinesState states = this.createIOLinesState(this.api.inputsInfo());
            ArrayList sensors = this.getSensors();
            for (int i = 0; i < states.getSize(); ++i) {
                Sensor sensor = (Sensor)sensors.get(i);
                LineState lineState = states.getLineState(i);
                sensor.notifyListeners(lineState.getValue());
            }
        }
        catch (IOControllerException ex) {
            throw new IOException(ex);
        }
    }

    public IOController getIOController() {
        return this;
    }

    public IOLinesState getOutputStatus() throws IOControllerException {
        return this.createIOLinesState(this.api.outputsInfo());
    }

    public IOLinesState getInputStatus() throws IOControllerException {
        return this.createIOLinesState(this.api.inputsInfo());
    }

    public void setOutputStatus(int line, LineState status) throws IOControllerException {
        if (line == -1) {
            this.api.outs(status == LineState.STATUS_ON);
        } else {
            this.api.outNN(line, status == LineState.STATUS_ON);
        }
    }

    public IOLinesState createIOLinesState(int bitmap) {
        ArrayList<LineState> arrayList = new ArrayList<LineState>();
        for (int i = 0; i < 20; ++i) {
            int currentBit = bitmap & 1 << i;
            arrayList.add(currentBit != 0 ? LineState.STATUS_ON : LineState.STATUS_OFF);
        }
        return new IOLinesState(arrayList);
    }

    public class DoorTaskCIO20
    implements DoorTask {
        private final Thread task;
        private final int number;

        public DoorTaskCIO20(Thread task, int number) {
            this.task = task;
            this.number = number;
        }

        public void cancel() throws IOControllerException {
            Driver.this.log.info((Object)"Cancel 'open door' task");
            if (this.task.isAlive()) {
                Driver.this.log.info((Object)"Task is alive");
                this.task.interrupt();
                try {
                    this.task.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                Driver.this.log.info((Object)"Task was joined");
            }
            Driver.this.log.info((Object)("Close cell number: " + this.number));
            Driver.this.setOutputStatus(this.number, LineState.STATUS_OFF);
        }
    }

    public class CIO20DoorApi
    implements DoorApi {
        public DoorTask openDoor(final int number) throws IOControllerException {
            Runnable task = new Runnable(){

                private Sensor searchSensorById(int number2) {
                    for (Sensor s : Driver.this.getSensors()) {
                        if (s.getId() != number2) continue;
                        return s;
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Driver.this.log.info((Object)"Start open door task...");
                    final Object lock = new Object();
                    final boolean[] doorOpen = new boolean[]{false};
                    Sensor sensor = this.searchSensorById(number);
                    if (sensor == null) {
                        return;
                    }
                    Driver.this.log.info((Object)("Select sensor: " + sensor));
                    SensorsListener sensorsListener = new SensorsListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onChange(SensorEvent event) {
                            if (event.getType() == 1) {
                                Driver.this.log.info((Object)"The door was opened");
                                Object object = lock;
                                synchronized (object) {
                                    doorOpen[0] = true;
                                    lock.notify();
                                }
                            }
                        }
                    };
                    sensor.addListener(sensorsListener);
                    try {
                        int attempt = 0;
                        while (!doorOpen[0]) {
                            Driver.this.log.info((Object)("Attempt #" + attempt++));
                            Driver.this.setOutputStatus(number, LineState.STATUS_ON);
                            Driver.this.sleep(1500);
                            Driver.this.setOutputStatus(number, LineState.STATUS_OFF);
                            Object object = lock;
                            synchronized (object) {
                                if (!doorOpen[0]) {
                                    lock.wait(5000L);
                                }
                            }
                        }
                        return;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        Driver.this.log.warn((Object)ex.getMessage());
                        return;
                    }
                    catch (Exception ex) {
                        Driver.this.log.error((Object)ex, (Throwable)ex);
                        return;
                    }
                    finally {
                        sensor.removeListener(sensorsListener);
                        Driver.this.log.info((Object)"...stop open door task");
                    }
                }
            };
            Thread taskThread = new Thread(task);
            taskThread.start();
            return new DoorTaskCIO20(taskThread, number);
        }
    }
}

