/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NativeUtils {
    private static final String WORD_SIZE = System.getProperty("sun.arch.data.model");
    private static final String ARCH = System.getProperty("os.arch");
    private static final String EXT = System.getProperty("os.name").toLowerCase().contains("win") ? ".dll" : ".so";

    private NativeUtils() {
    }

    public static void loadLibraryFromJar(String path, String name) {
        System.load(NativeUtils.uploadLibrary(path, name));
    }

    public static String uploadLibrary(String path, String name) {
        if (path == null || path.isEmpty() || !path.startsWith("/")) {
            throw new IllegalArgumentException("Path is wrong");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Library name is wrong");
        }
        try {
            String fullName = name + "-" + ("arm".equalsIgnoreCase(ARCH) ? "arm-" : "") + WORD_SIZE + EXT;
            File temp = File.createTempFile(name, EXT + ".sl");
            temp.deleteOnExit();
            return NativeUtils.uploadLibrary(temp, path, fullName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadLibrary(File tempFile, String path, String name) throws IOException {
        byte[] buffer = new byte[1024];
        String fpath = (path + "/" + name).replaceAll("/{2,}", "/");
        InputStream is = NativeUtils.class.getResourceAsStream(fpath);
        if (is == null) {
            throw new FileNotFoundException("File " + fpath + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(tempFile);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            NativeUtils.close(os);
            NativeUtils.close(is);
        }
        return tempFile.getAbsolutePath();
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

