/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Storage;
import ru.softlogic.io.utils.BU;

public class StartStorage
implements Storage {
    private static final int DEFAULT_DEPTH = 24;
    private byte[] res;
    private List<Byte> garbage;
    private final Set<Byte> targets;
    private final int needs;
    private final int depth;

    public StartStorage(byte start, int needs) {
        this(start, needs, 24);
    }

    public StartStorage(byte start, int needs, int depth) {
        this(StartStorage.convert(start), needs, depth);
    }

    public StartStorage(Set<Byte> targets, int needs) {
        this(targets, needs, 24);
    }

    public StartStorage(Set<Byte> targets, int needs, int depth) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Targets must be filled");
        }
        if (needs <= 0) {
            throw new IllegalArgumentException("Count is wrong: " + needs + ", value must be positive");
        }
        if (depth <= 0 || depth > 255) {
            throw new IllegalArgumentException("Depth is wrong: " + depth + ", value must be in range [0..255]");
        }
        this.targets = targets;
        this.needs = needs;
        this.depth = depth;
    }

    @Override
    public boolean add(byte b, BasePort port) throws IOException {
        if (this.targets.contains(b)) {
            if (this.needs > 1) {
                byte[] oth = port.read(this.needs - 1);
                this.res = new byte[this.needs];
                this.res[0] = b;
                System.arraycopy(oth, 0, this.res, 1, oth.length);
            } else {
                this.res = new byte[]{b};
            }
            return false;
        }
        if (this.garbage == null) {
            this.garbage = new LinkedList<Byte>();
        }
        this.garbage.add(b);
        if (this.garbage.size() > this.depth) {
            throw new IOException("Can't find start byte " + BU.toStringEx(this.targets) + ", readed: " + BU.toString(this.garbage));
        }
        return true;
    }

    private static Set<Byte> convert(byte b) {
        HashSet<Byte> res = new HashSet<Byte>();
        res.add(b);
        return res;
    }

    @Override
    public byte[] getResult() {
        return this.res;
    }
}

