/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.apps;

import java.io.File;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Xmlutils {
    public static void main(String[] args) {
        if (args == null || args.length != 3) {
            System.out.println("java -jar xmlutils.jar <path_to_file> <xpath_request> <new_value>");
            System.out.println("    Example: java -jar xmlutil.jar test.xml /PersonList/Person[@id='1']/@id 5");
            System.exit(1);
            return;
        }
        System.out.println(Arrays.toString(args));
        File file = new File(args[0].trim());
        System.out.println("Process " + file.getAbsolutePath());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(file);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(args[1].trim());
            Node node = (Node)expr.evaluate(doc, XPathConstants.NODE);
            if (node == null) {
                throw new Exception("Node is not found");
            }
            node.setTextContent(args[2].trim());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            System.out.println("Success");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(2);
        }
    }
}

