/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.CRC32;

public class Utils {
    private static int length;

    public static File getRoot() {
        String dir = System.getProperty("app.dir");
        return dir != null && !dir.isEmpty() ? new File(dir) : new File(".");
    }

    public static File getScheme() {
        String dir = System.getProperty("scheme.dir");
        return dir != null && !dir.isEmpty() ? new File(dir) : new File(Utils.getRoot(), "/scheme/");
    }

    public static synchronized String getRelativePath(File file) {
        if (length == 0) {
            length = Utils.getRoot().getAbsolutePath().length();
        }
        return file.getAbsolutePath().substring(length + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateChecksum(File file) {
        FileInputStream fis = null;
        try {
            int l;
            CRC32 cs = new CRC32();
            cs.reset();
            fis = new FileInputStream(file);
            byte[] buf = new byte[1024];
            while ((l = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l);
            }
            fis.close();
            long l2 = cs.getValue();
            return l2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0L;
    }

    public static void updateVersion() {
        int version = Utils.getVersion();
        version = version < 0 ? 0 : (version >= 99 ? 0 : ++version);
        System.out.println("Generate new version: " + version);
        Utils.setVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getVersion() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("update.build"), "utf-8"));
            String line = br.readLine();
            int n = Integer.parseInt(line);
            return n;
        }
        catch (Exception ex) {
            int n = 0;
            return n;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVersion(int version) {
        OutputStreamWriter bw = null;
        try {
            bw = new FileWriter(new File("update.build"));
            bw.append(Integer.toString(version));
            bw.flush();
        }
        catch (Exception ex) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setListParams(long listCrc, long size, long modified) {
        OutputStreamWriter bw = null;
        try {
            bw = new FileWriter(new File("list.crc"));
            bw.append(Long.toString(listCrc) + " " + Long.toString(size) + " " + modified);
            bw.flush();
        }
        catch (Exception ex) {
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {}
            }
        }
    }
}

